/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.slidingrootnav;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yarolegovich.slidingrootnav.SlideGravity;
import com.yarolegovich.slidingrootnav.SlidingRootNav;
import com.yarolegovich.slidingrootnav.callback.DragListener;
import com.yarolegovich.slidingrootnav.callback.DragStateListener;
import com.yarolegovich.slidingrootnav.transform.RootTransformation;
import java.util.ArrayList;
import java.util.List;

public class SlidingRootNavLayout
extends FrameLayout
implements SlidingRootNav {
    private static final String EXTRA_IS_OPENED = "extra_is_opened";
    private static final String EXTRA_SUPER = "extra_super";
    private final float FLING_MIN_VELOCITY;
    private boolean isMenuLocked;
    private RootTransformation rootTransformation;
    private View rootView;
    private float dragProgress;
    private int maxDragDistance;
    private int dragState;
    private ViewDragHelper dragHelper;
    private SlideGravity.Helper positionHelper;
    private List<DragListener> dragListeners = new ArrayList<DragListener>();
    private List<DragStateListener> dragStateListeners = new ArrayList<DragStateListener>();

    public SlidingRootNavLayout(Context context) {
        super(context);
        this.FLING_MIN_VELOCITY = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragCallback());
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return !this.isMenuLocked && this.dragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.dragHelper.processTouchEvent(event);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.rootView) {
                int rootLeft = this.positionHelper.getRootLeft(this.dragProgress, this.maxDragDistance);
                child.layout(rootLeft, top, rootLeft + (right - left), bottom);
                continue;
            }
            child.layout(left, top, right, bottom);
        }
    }

    public void computeScroll() {
        if (this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private void changeMenuVisibility(boolean animated, float newDragProgress) {
        if (animated) {
            int left = this.positionHelper.getLeftToSettle(newDragProgress, this.maxDragDistance);
            if (this.dragHelper.smoothSlideViewTo(this.rootView, left, this.rootView.getTop())) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        } else {
            this.dragProgress = newDragProgress;
            this.rootTransformation.transform(this.dragProgress, this.rootView);
            this.requestLayout();
        }
    }

    @Override
    public boolean isMenuHidden() {
        return this.dragProgress == 0.0f;
    }

    @Override
    public SlidingRootNavLayout getLayout() {
        return this;
    }

    @Override
    public boolean isMenuLocked() {
        return this.isMenuLocked;
    }

    @Override
    public void closeMenu() {
        this.closeMenu(true);
    }

    @Override
    public void closeMenu(boolean animated) {
        this.changeMenuVisibility(animated, 0.0f);
    }

    @Override
    public void openMenu() {
        this.openMenu(true);
    }

    @Override
    public void openMenu(boolean animated) {
        this.changeMenuVisibility(animated, 1.0f);
    }

    @Override
    public void setMenuLocked(boolean locked) {
        this.isMenuLocked = locked;
    }

    public void setRootView(View view) {
        this.rootView = view;
    }

    public void setRootTransformation(RootTransformation transformation) {
        this.rootTransformation = transformation;
    }

    public void setMaxDragDistance(int maxDragDistance) {
        this.maxDragDistance = maxDragDistance;
    }

    public void setGravity(SlideGravity gravity) {
        this.positionHelper = gravity.createHelper();
        this.positionHelper.enableEdgeTrackingOn(this.dragHelper);
    }

    public void addDragListener(DragListener listener) {
        this.dragListeners.add(listener);
    }

    public void addDragStateListener(DragStateListener listener) {
        this.dragStateListeners.add(listener);
    }

    public void removeDragListener(DragListener listener) {
        this.dragListeners.remove(listener);
    }

    public void removeDragStateListener(DragStateListener listener) {
        this.dragStateListeners.remove(listener);
    }

    public float getDragProgress() {
        return this.dragProgress;
    }

    private void notifyDrag() {
        for (DragListener listener : this.dragListeners) {
            listener.onDrag(this.dragProgress);
        }
    }

    private void notifyDragStart() {
        for (DragStateListener listener : this.dragStateListeners) {
            listener.onDragStart();
        }
    }

    private void notifyDragEnd(boolean isOpened) {
        for (DragStateListener listener : this.dragStateListeners) {
            listener.onDragEnd(isOpened);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle savedState = new Bundle();
        savedState.putParcelable(EXTRA_SUPER, super.onSaveInstanceState());
        savedState.putInt(EXTRA_IS_OPENED, (double)this.dragProgress > 0.5 ? 1 : 0);
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        Bundle savedState = (Bundle)state;
        super.onRestoreInstanceState(savedState.getParcelable(EXTRA_SUPER));
        this.changeMenuVisibility(false, savedState.getInt(EXTRA_IS_OPENED, 0));
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private boolean edgeTouched;

        private ViewDragCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidingRootNavLayout.this.isMenuLocked) {
                return false;
            }
            boolean isOnEdge = this.edgeTouched;
            this.edgeTouched = false;
            if (SlidingRootNavLayout.this.isMenuHidden()) {
                return child == SlidingRootNavLayout.this.rootView && isOnEdge;
            }
            if (child != SlidingRootNavLayout.this.rootView) {
                SlidingRootNavLayout.this.dragHelper.captureChildView(SlidingRootNavLayout.this.rootView, pointerId);
                return false;
            }
            return true;
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidingRootNavLayout.this.dragProgress = SlidingRootNavLayout.this.positionHelper.getDragProgress(left, SlidingRootNavLayout.this.maxDragDistance);
            SlidingRootNavLayout.this.rootTransformation.transform(SlidingRootNavLayout.this.dragProgress, SlidingRootNavLayout.this.rootView);
            SlidingRootNavLayout.this.notifyDrag();
            SlidingRootNavLayout.this.invalidate();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int left = Math.abs(xvel) < SlidingRootNavLayout.this.FLING_MIN_VELOCITY ? SlidingRootNavLayout.this.positionHelper.getLeftToSettle(SlidingRootNavLayout.this.dragProgress, SlidingRootNavLayout.this.maxDragDistance) : SlidingRootNavLayout.this.positionHelper.getLeftAfterFling(xvel, SlidingRootNavLayout.this.maxDragDistance);
            SlidingRootNavLayout.this.dragHelper.settleCapturedViewAt(left, SlidingRootNavLayout.this.rootView.getTop());
            SlidingRootNavLayout.this.invalidate();
        }

        public void onViewDragStateChanged(int state) {
            if (SlidingRootNavLayout.this.dragState == 0 && state != 0) {
                SlidingRootNavLayout.this.notifyDragStart();
            } else if (SlidingRootNavLayout.this.dragState != 0 && state == 0) {
                SlidingRootNavLayout.this.notifyDragEnd(!SlidingRootNavLayout.this.isMenuHidden());
            }
            SlidingRootNavLayout.this.dragState = state;
        }

        public void onEdgeTouched(int edgeFlags, int pointerId) {
            this.edgeTouched = true;
        }

        public int getViewHorizontalDragRange(View child) {
            return child == SlidingRootNavLayout.this.rootView ? SlidingRootNavLayout.this.maxDragDistance : 0;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            return SlidingRootNavLayout.this.positionHelper.clampViewPosition(left, SlidingRootNavLayout.this.maxDragDistance);
        }
    }
}

