/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.slidingrootnav;

import android.support.v4.widget.ViewDragHelper;

public enum SlideGravity {
    LEFT{

        @Override
        Helper createHelper() {
            return new LeftHelper();
        }
    }
    ,
    RIGHT{

        @Override
        Helper createHelper() {
            return new RightHelper();
        }
    };


    abstract Helper createHelper();

    static class RightHelper
    implements Helper {
        RightHelper() {
        }

        @Override
        public int getLeftAfterFling(float flingVelocity, int maxDrag) {
            return flingVelocity > 0.0f ? 0 : -maxDrag;
        }

        @Override
        public int getLeftToSettle(float dragProgress, int maxDrag) {
            return dragProgress > 0.5f ? -maxDrag : 0;
        }

        @Override
        public int getRootLeft(float dragProgress, int maxDrag) {
            return (int)(-(dragProgress * (float)maxDrag));
        }

        @Override
        public float getDragProgress(int viewLeft, int maxDrag) {
            return (float)Math.abs(viewLeft) / (float)maxDrag;
        }

        @Override
        public int clampViewPosition(int left, int maxDrag) {
            return Math.max(-maxDrag, Math.min(left, 0));
        }

        @Override
        public void enableEdgeTrackingOn(ViewDragHelper dragHelper) {
            dragHelper.setEdgeTrackingEnabled(2);
        }
    }

    static class LeftHelper
    implements Helper {
        LeftHelper() {
        }

        @Override
        public int getLeftAfterFling(float flingVelocity, int maxDrag) {
            return flingVelocity > 0.0f ? maxDrag : 0;
        }

        @Override
        public int getLeftToSettle(float dragProgress, int maxDrag) {
            return dragProgress > 0.5f ? maxDrag : 0;
        }

        @Override
        public int getRootLeft(float dragProgress, int maxDrag) {
            return (int)(dragProgress * (float)maxDrag);
        }

        @Override
        public float getDragProgress(int viewLeft, int maxDrag) {
            return (float)viewLeft / (float)maxDrag;
        }

        @Override
        public int clampViewPosition(int left, int maxDrag) {
            return Math.max(0, Math.min(left, maxDrag));
        }

        @Override
        public void enableEdgeTrackingOn(ViewDragHelper dragHelper) {
            dragHelper.setEdgeTrackingEnabled(1);
        }
    }

    static interface Helper {
        public int getLeftAfterFling(float var1, int var2);

        public int getLeftToSettle(float var1, int var2);

        public int getRootLeft(float var1, int var2);

        public float getDragProgress(int var1, int var2);

        public int clampViewPosition(int var1, int var2);

        public void enableEdgeTrackingOn(ViewDragHelper var1);
    }
}

