/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.widget.NestedScrollView;
import java.util.ArrayList;
import java.util.List;

public class StickyNestedScrollView
extends NestedScrollView {
    public static final String STICKY_TAG = "sticky";
    public static final String FLAG_NONCONSTANT = "-nonconstant";
    public static final String FLAG_HASTRANSPARENCY = "-hastransparency";
    private static final int DEFAULT_SHADOW_HEIGHT = 10;
    private ArrayList<View> stickyViews;
    private View currentlyStickingView;
    private float stickyViewTopOffset;
    private final Runnable invalidateRunnable = new Runnable(){

        @Override
        public void run() {
            if (StickyNestedScrollView.this.currentlyStickingView != null) {
                int l = StickyNestedScrollView.this.getLeftForViewRelativeOnlyChild(StickyNestedScrollView.this.currentlyStickingView);
                int t = StickyNestedScrollView.this.getBottomForViewRelativeOnlyChild(StickyNestedScrollView.this.currentlyStickingView);
                int r = StickyNestedScrollView.this.getRightForViewRelativeOnlyChild(StickyNestedScrollView.this.currentlyStickingView);
                int b = (int)((float)StickyNestedScrollView.this.getScrollY() + ((float)StickyNestedScrollView.this.currentlyStickingView.getHeight() + StickyNestedScrollView.this.stickyViewTopOffset));
                StickyNestedScrollView.this.invalidate(l, t, r, b);
            }
            StickyNestedScrollView.this.postDelayed(this, 16L);
        }
    };
    private int stickyViewLeftOffset;
    private boolean redirectTouchesToStickyView;
    private boolean clippingToPadding;
    private boolean clipToPaddingHasBeenSet;
    private int mShadowHeight = 10;
    private Drawable mShadowDrawable;
    private boolean hasNotDoneActionDown = true;
    private List<OnViewStickyListener> mOnViewStickyListeners;

    public StickyNestedScrollView(Context context) {
        this(context, null);
    }

    public StickyNestedScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010080);
    }

    public StickyNestedScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup();
    }

    public void addOnViewStickyListener(OnViewStickyListener stickyListener) {
        if (this.mOnViewStickyListeners == null) {
            this.mOnViewStickyListeners = new ArrayList<OnViewStickyListener>();
        }
        this.mOnViewStickyListeners.add(stickyListener);
    }

    public void removeOnViewStickyListener(OnViewStickyListener stickyListener) {
        if (this.mOnViewStickyListeners != null) {
            this.mOnViewStickyListeners.remove(stickyListener);
        }
    }

    public void clearOnViewStickyListener() {
        if (this.mOnViewStickyListeners != null) {
            this.mOnViewStickyListeners.clear();
        }
    }

    public void setShadowHeight(int height) {
        this.mShadowHeight = height;
    }

    public void setShadowDrawable(Drawable shadowDrawable) {
        this.mShadowDrawable = shadowDrawable;
    }

    public void setup() {
        this.stickyViews = new ArrayList();
    }

    private int getLeftForViewRelativeOnlyChild(View v) {
        int left = v.getLeft();
        while (v.getParent() != null && v.getParent() != this.getChildAt(0)) {
            v = (View)v.getParent();
            left += v.getLeft();
        }
        return left;
    }

    private int getTopForViewRelativeOnlyChild(View v) {
        int top = v.getTop();
        while (v.getParent() != null && v.getParent() != this.getChildAt(0)) {
            v = (View)v.getParent();
            top += v.getTop();
        }
        return top;
    }

    private int getRightForViewRelativeOnlyChild(View v) {
        int right = v.getRight();
        while (v.getParent() != null && v.getParent() != this.getChildAt(0)) {
            v = (View)v.getParent();
            right += v.getRight();
        }
        return right;
    }

    private int getBottomForViewRelativeOnlyChild(View v) {
        int bottom = v.getBottom();
        while (v.getParent() != null && v.getParent() != this.getChildAt(0)) {
            v = (View)v.getParent();
            bottom += v.getBottom();
        }
        return bottom;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.clipToPaddingHasBeenSet) {
            this.clippingToPadding = true;
        }
        this.notifyHierarchyChanged();
    }

    public void setClipToPadding(boolean clipToPadding) {
        super.setClipToPadding(clipToPadding);
        this.clippingToPadding = clipToPadding;
        this.clipToPaddingHasBeenSet = true;
    }

    public void addView(View child) {
        super.addView(child);
        this.findStickyViews(child);
    }

    public void addView(View child, int index) {
        super.addView(child, index);
        this.findStickyViews(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        this.findStickyViews(child);
    }

    public void addView(View child, int width, int height) {
        super.addView(child, width, height);
        this.findStickyViews(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        super.addView(child, params);
        this.findStickyViews(child);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.currentlyStickingView != null) {
            canvas.save();
            canvas.translate((float)(this.getPaddingLeft() + this.stickyViewLeftOffset), (float)this.getScrollY() + this.stickyViewTopOffset + (float)(this.clippingToPadding ? this.getPaddingTop() : 0));
            canvas.clipRect(0.0f, this.clippingToPadding ? -this.stickyViewTopOffset : 0.0f, (float)(this.getWidth() - this.stickyViewLeftOffset), (float)(this.currentlyStickingView.getHeight() + this.mShadowHeight + 1));
            if (this.mShadowDrawable != null) {
                int left = 0;
                int top = this.currentlyStickingView.getHeight();
                int right = this.currentlyStickingView.getWidth();
                int bottom = this.currentlyStickingView.getHeight() + this.mShadowHeight;
                this.mShadowDrawable.setBounds(left, top, right, bottom);
                this.mShadowDrawable.draw(canvas);
            }
            canvas.clipRect(0.0f, this.clippingToPadding ? -this.stickyViewTopOffset : 0.0f, (float)this.getWidth(), (float)this.currentlyStickingView.getHeight());
            if (this.getStringTagForView(this.currentlyStickingView).contains(FLAG_HASTRANSPARENCY)) {
                this.showView(this.currentlyStickingView);
                this.currentlyStickingView.draw(canvas);
                this.hideView(this.currentlyStickingView);
            } else {
                this.currentlyStickingView.draw(canvas);
            }
            canvas.restore();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.redirectTouchesToStickyView = true;
        }
        if (this.redirectTouchesToStickyView) {
            boolean bl = this.redirectTouchesToStickyView = this.currentlyStickingView != null;
            if (this.redirectTouchesToStickyView) {
                this.redirectTouchesToStickyView = ev.getY() <= (float)this.currentlyStickingView.getHeight() + this.stickyViewTopOffset && ev.getX() >= (float)this.getLeftForViewRelativeOnlyChild(this.currentlyStickingView) && ev.getX() <= (float)this.getRightForViewRelativeOnlyChild(this.currentlyStickingView);
            }
        } else if (this.currentlyStickingView == null) {
            this.redirectTouchesToStickyView = false;
        }
        if (this.redirectTouchesToStickyView) {
            ev.offsetLocation(0.0f, -1.0f * ((float)this.getScrollY() + this.stickyViewTopOffset - (float)this.getTopForViewRelativeOnlyChild(this.currentlyStickingView)));
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.redirectTouchesToStickyView) {
            ev.offsetLocation(0.0f, (float)this.getScrollY() + this.stickyViewTopOffset - (float)this.getTopForViewRelativeOnlyChild(this.currentlyStickingView));
        }
        if (ev.getAction() == 0) {
            this.hasNotDoneActionDown = false;
        }
        if (this.hasNotDoneActionDown) {
            MotionEvent down = MotionEvent.obtain((MotionEvent)ev);
            down.setAction(0);
            super.onTouchEvent(down);
            this.hasNotDoneActionDown = false;
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.hasNotDoneActionDown = true;
        }
        return super.onTouchEvent(ev);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.doTheStickyThing();
    }

    private void doTheStickyThing() {
        View viewThatShouldStick = null;
        View approachingView = null;
        for (View v : this.stickyViews) {
            int viewTop = this.getTopForViewRelativeOnlyChild(v) - this.getScrollY() + (this.clippingToPadding ? 0 : this.getPaddingTop());
            if (viewTop <= 0) {
                if (viewThatShouldStick != null && viewTop <= this.getTopForViewRelativeOnlyChild(viewThatShouldStick) - this.getScrollY() + (this.clippingToPadding ? 0 : this.getPaddingTop())) continue;
                viewThatShouldStick = v;
                continue;
            }
            if (approachingView != null && viewTop >= this.getTopForViewRelativeOnlyChild(approachingView) - this.getScrollY() + (this.clippingToPadding ? 0 : this.getPaddingTop())) continue;
            approachingView = v;
        }
        if (viewThatShouldStick != null) {
            float f = approachingView == null ? 0.0f : (this.stickyViewTopOffset = (float)Math.min(0, this.getTopForViewRelativeOnlyChild(approachingView) - this.getScrollY() + (this.clippingToPadding ? 0 : this.getPaddingTop()) - viewThatShouldStick.getHeight()));
            if (viewThatShouldStick != this.currentlyStickingView) {
                if (this.currentlyStickingView != null) {
                    if (this.mOnViewStickyListeners != null) {
                        for (OnViewStickyListener onViewStickyListener : this.mOnViewStickyListeners) {
                            onViewStickyListener.onUnSticky(this.currentlyStickingView);
                        }
                    }
                    this.stopStickingCurrentlyStickingView();
                }
                this.stickyViewLeftOffset = this.getLeftForViewRelativeOnlyChild(viewThatShouldStick);
                this.startStickingView(viewThatShouldStick);
                if (this.mOnViewStickyListeners != null) {
                    for (OnViewStickyListener onViewStickyListener : this.mOnViewStickyListeners) {
                        onViewStickyListener.onSticky(this.currentlyStickingView);
                    }
                }
            }
        } else if (this.currentlyStickingView != null) {
            if (this.mOnViewStickyListeners != null) {
                for (OnViewStickyListener onViewStickyListener : this.mOnViewStickyListeners) {
                    onViewStickyListener.onUnSticky(this.currentlyStickingView);
                }
            }
            this.stopStickingCurrentlyStickingView();
        }
    }

    private void startStickingView(View viewThatShouldStick) {
        this.currentlyStickingView = viewThatShouldStick;
        if (this.currentlyStickingView != null) {
            if (this.getStringTagForView(this.currentlyStickingView).contains(FLAG_HASTRANSPARENCY)) {
                this.hideView(this.currentlyStickingView);
            }
            if (this.getStringTagForView(this.currentlyStickingView).contains(FLAG_NONCONSTANT)) {
                this.post(this.invalidateRunnable);
            }
        }
    }

    private void stopStickingCurrentlyStickingView() {
        if (this.getStringTagForView(this.currentlyStickingView).contains(FLAG_HASTRANSPARENCY)) {
            this.showView(this.currentlyStickingView);
        }
        this.currentlyStickingView = null;
        this.removeCallbacks(this.invalidateRunnable);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.invalidateRunnable);
        super.onDetachedFromWindow();
    }

    public void notifyStickyAttributeChanged() {
        this.notifyHierarchyChanged();
    }

    private void notifyHierarchyChanged() {
        if (this.currentlyStickingView != null) {
            this.stopStickingCurrentlyStickingView();
        }
        this.stickyViews.clear();
        this.findStickyViews(this.getChildAt(0));
        this.doTheStickyThing();
        this.invalidate();
    }

    private void findStickyViews(View v) {
        if (!this.detainStickyView(v) && v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = 0; i < vg.getChildCount(); ++i) {
                this.findStickyViews(vg.getChildAt(i));
            }
        }
    }

    private boolean detainStickyView(View view) {
        String tag = this.getStringTagForView(view);
        if (tag.contains(STICKY_TAG)) {
            this.stickyViews.add(view);
            return true;
        }
        return false;
    }

    private String getStringTagForView(View v) {
        Object tagObject = v.getTag();
        return String.valueOf(tagObject);
    }

    private void hideView(View v) {
        v.setAlpha(0.0f);
    }

    private void showView(View v) {
        v.setAlpha(1.0f);
    }

    public static interface OnViewStickyListener {
        public void onSticky(View var1);

        public void onUnSticky(View var1);
    }
}

