/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yanzhenjie.recyclerview.SwipeRecyclerView;
import com.yanzhenjie.recyclerview.x.R;

public class DefaultLoadMoreView
extends LinearLayout
implements SwipeRecyclerView.LoadMoreView,
View.OnClickListener {
    private ProgressBar mProgressBar;
    private TextView mTvMessage;
    private SwipeRecyclerView.LoadMoreListener mLoadMoreListener;

    public DefaultLoadMoreView(Context context) {
        this(context, null);
    }

    public DefaultLoadMoreView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.setGravity(17);
        this.setVisibility(8);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int minHeight = (int)((double)(displayMetrics.density * 60.0f) + 0.5);
        this.setMinimumHeight(minHeight);
        DefaultLoadMoreView.inflate((Context)this.getContext(), (int)R.layout.x_recycler_view_load_more, (ViewGroup)this);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.mTvMessage = (TextView)this.findViewById(R.id.tv_load_more_message);
        this.setOnClickListener(this);
    }

    @Override
    public void onLoading() {
        this.setVisibility(0);
        this.mProgressBar.setVisibility(0);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText(R.string.x_recycler_load_more_message);
    }

    @Override
    public void onLoadFinish(boolean dataEmpty, boolean hasMore) {
        if (!hasMore) {
            this.setVisibility(0);
            if (dataEmpty) {
                this.mProgressBar.setVisibility(8);
                this.mTvMessage.setVisibility(0);
                this.mTvMessage.setText(R.string.x_recycler_data_empty);
            } else {
                this.mProgressBar.setVisibility(8);
                this.mTvMessage.setVisibility(0);
                this.mTvMessage.setText(R.string.x_recycler_more_not);
            }
        } else {
            this.setVisibility(4);
        }
    }

    @Override
    public void onWaitToLoadMore(SwipeRecyclerView.LoadMoreListener loadMoreListener) {
        this.mLoadMoreListener = loadMoreListener;
        this.setVisibility(0);
        this.mProgressBar.setVisibility(8);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText(R.string.x_recycler_click_load_more);
    }

    @Override
    public void onLoadError(int errorCode, String errorMessage) {
        this.setVisibility(0);
        this.mProgressBar.setVisibility(8);
        this.mTvMessage.setVisibility(0);
        this.mTvMessage.setText((CharSequence)(TextUtils.isEmpty((CharSequence)errorMessage) ? this.getContext().getString(R.string.x_recycler_load_error) : errorMessage));
    }

    public void onClick(View v) {
        if (this.mLoadMoreListener != null) {
            this.mLoadMoreListener.onLoadMore();
        }
    }
}

