/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.widget;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yanzhenjie.recyclerview.widget.ColorDrawer;
import com.yanzhenjie.recyclerview.widget.Drawer;

public class DefaultItemDecoration
extends RecyclerView.ItemDecoration {
    private final int mWidth;
    private final int mHeight;
    private final Drawer mDrawer;

    public DefaultItemDecoration(@ColorInt int color) {
        this(color, 4, 4);
    }

    public DefaultItemDecoration(@ColorInt int color, int width, int height) {
        this.mWidth = Math.round((float)width / 2.0f);
        this.mHeight = Math.round((float)height / 2.0f);
        this.mDrawer = new ColorDrawer(color, this.mWidth, this.mHeight);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            int orientation = this.getOrientation(layoutManager);
            int position = parent.getChildLayoutPosition(view);
            int spanCount = this.getSpanCount(layoutManager);
            int childCount = layoutManager.getItemCount();
            if (orientation == 1) {
                this.offsetVertical(outRect, position, spanCount, childCount);
            } else {
                this.offsetHorizontal(outRect, position, spanCount, childCount);
            }
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            outRect.set(this.mWidth, this.mHeight, this.mWidth, this.mHeight);
        }
    }

    private void offsetHorizontal(Rect outRect, int position, int spanCount, int childCount) {
        boolean firstRaw = this.isFirstRaw(0, position, spanCount, childCount);
        boolean lastRaw = this.isLastRaw(0, position, spanCount, childCount);
        boolean firstColumn = this.isFirstColumn(0, position, spanCount, childCount);
        boolean lastColumn = this.isLastColumn(0, position, spanCount, childCount);
        if (spanCount == 1) {
            if (firstColumn && lastColumn) {
                outRect.set(0, 0, 0, 0);
            } else if (firstColumn) {
                outRect.set(0, 0, this.mWidth, 0);
            } else if (lastColumn) {
                outRect.set(this.mWidth, 0, 0, 0);
            } else {
                outRect.set(this.mWidth, 0, this.mWidth, 0);
            }
        } else if (firstColumn && firstRaw) {
            outRect.set(0, 0, this.mWidth, this.mHeight);
        } else if (firstColumn && lastRaw) {
            outRect.set(0, this.mHeight, this.mWidth, 0);
        } else if (lastColumn && firstRaw) {
            outRect.set(this.mWidth, 0, 0, this.mHeight);
        } else if (lastColumn && lastRaw) {
            outRect.set(this.mWidth, this.mHeight, 0, 0);
        } else if (firstColumn) {
            outRect.set(0, this.mHeight, this.mWidth, this.mHeight);
        } else if (lastColumn) {
            outRect.set(this.mWidth, this.mHeight, 0, this.mHeight);
        } else if (firstRaw) {
            outRect.set(this.mWidth, 0, this.mWidth, this.mHeight);
        } else if (lastRaw) {
            outRect.set(this.mWidth, this.mHeight, this.mWidth, 0);
        } else {
            outRect.set(this.mWidth, this.mHeight, this.mWidth, this.mHeight);
        }
    }

    private void offsetVertical(Rect outRect, int position, int spanCount, int childCount) {
        boolean firstRaw = this.isFirstRaw(1, position, spanCount, childCount);
        boolean lastRaw = this.isLastRaw(1, position, spanCount, childCount);
        boolean firstColumn = this.isFirstColumn(1, position, spanCount, childCount);
        boolean lastColumn = this.isLastColumn(1, position, spanCount, childCount);
        if (spanCount == 1) {
            if (firstRaw && lastRaw) {
                outRect.set(0, 0, 0, 0);
            } else if (firstRaw) {
                outRect.set(0, 0, 0, this.mHeight);
            } else if (lastRaw) {
                outRect.set(0, this.mHeight, 0, 0);
            } else {
                outRect.set(0, this.mHeight, 0, this.mHeight);
            }
        } else if (firstRaw && firstColumn) {
            outRect.set(0, 0, this.mWidth, this.mHeight);
        } else if (firstRaw && lastColumn) {
            outRect.set(this.mWidth, 0, 0, this.mHeight);
        } else if (lastRaw && firstColumn) {
            outRect.set(0, this.mHeight, this.mWidth, 0);
        } else if (lastRaw && lastColumn) {
            outRect.set(this.mWidth, this.mHeight, 0, 0);
        } else if (firstRaw) {
            outRect.set(this.mWidth, 0, this.mWidth, this.mHeight);
        } else if (lastRaw) {
            outRect.set(this.mWidth, this.mHeight, this.mWidth, 0);
        } else if (firstColumn) {
            outRect.set(0, this.mHeight, this.mWidth, this.mHeight);
        } else if (lastColumn) {
            outRect.set(this.mWidth, this.mHeight, 0, this.mHeight);
        } else {
            outRect.set(this.mWidth, this.mHeight, this.mWidth, this.mHeight);
        }
    }

    private int getOrientation(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).getOrientation();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        }
        return 1;
    }

    private int getSpanCount(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            return ((GridLayoutManager)layoutManager).getSpanCount();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
        }
        return 1;
    }

    private boolean isFirstRaw(int orientation, int position, int columnCount, int childCount) {
        if (orientation == 1) {
            return position < columnCount;
        }
        if (columnCount == 1) {
            return true;
        }
        return position % columnCount == 0;
    }

    private boolean isLastRaw(int orientation, int position, int columnCount, int childCount) {
        if (orientation == 1) {
            if (columnCount == 1) {
                return position + 1 == childCount;
            }
            int lastRawItemCount = childCount % columnCount;
            int rawCount = (childCount - lastRawItemCount) / columnCount + (lastRawItemCount > 0 ? 1 : 0);
            int rawPositionJudge = (position + 1) % columnCount;
            if (rawPositionJudge == 0) {
                int positionRaw = (position + 1) / columnCount;
                return rawCount == positionRaw;
            }
            int rawPosition = (position + 1 - rawPositionJudge) / columnCount + 1;
            return rawCount == rawPosition;
        }
        if (columnCount == 1) {
            return true;
        }
        return (position + 1) % columnCount == 0;
    }

    private boolean isFirstColumn(int orientation, int position, int columnCount, int childCount) {
        if (orientation == 1) {
            if (columnCount == 1) {
                return true;
            }
            return position % columnCount == 0;
        }
        return position < columnCount;
    }

    private boolean isLastColumn(int orientation, int position, int columnCount, int childCount) {
        if (orientation == 1) {
            if (columnCount == 1) {
                return true;
            }
            return (position + 1) % columnCount == 0;
        }
        if (columnCount == 1) {
            return position + 1 == childCount;
        }
        int lastRawItemCount = childCount % columnCount;
        int rawCount = (childCount - lastRawItemCount) / columnCount + (lastRawItemCount > 0 ? 1 : 0);
        int rawPositionJudge = (position + 1) % columnCount;
        if (rawPositionJudge == 0) {
            int positionRaw = (position + 1) / columnCount;
            return rawCount == positionRaw;
        }
        int rawPosition = (position + 1 - rawPositionJudge) / columnCount + 1;
        return rawCount == rawPosition;
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        assert (layoutManager != null);
        int orientation = this.getOrientation(layoutManager);
        int spanCount = this.getSpanCount(layoutManager);
        int childCount = layoutManager.getChildCount();
        if (layoutManager instanceof LinearLayoutManager) {
            canvas.save();
            for (int i = 0; i < childCount; ++i) {
                View view = layoutManager.getChildAt(i);
                assert (view != null);
                int position = parent.getChildLayoutPosition(view);
                if (orientation == 1) {
                    this.drawVertical(canvas, view, position, spanCount, childCount);
                    continue;
                }
                this.drawHorizontal(canvas, view, position, spanCount, childCount);
            }
            canvas.restore();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            canvas.save();
            for (int i = 0; i < childCount; ++i) {
                View view = layoutManager.getChildAt(i);
                this.mDrawer.drawLeft(view, canvas);
                this.mDrawer.drawTop(view, canvas);
                this.mDrawer.drawRight(view, canvas);
                this.mDrawer.drawBottom(view, canvas);
            }
            canvas.restore();
        }
    }

    private void drawHorizontal(Canvas canvas, View view, int position, int spanCount, int childCount) {
        boolean firstRaw = this.isFirstRaw(0, position, spanCount, childCount);
        boolean lastRaw = this.isLastRaw(0, position, spanCount, childCount);
        boolean firstColumn = this.isFirstColumn(0, position, spanCount, childCount);
        boolean lastColumn = this.isLastColumn(0, position, spanCount, childCount);
        if (spanCount == 1) {
            if (!firstRaw || !lastColumn) {
                if (firstColumn) {
                    this.mDrawer.drawRight(view, canvas);
                } else if (lastColumn) {
                    this.mDrawer.drawLeft(view, canvas);
                } else {
                    this.mDrawer.drawLeft(view, canvas);
                    this.mDrawer.drawRight(view, canvas);
                }
            }
        } else if (firstColumn && firstRaw) {
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (firstColumn && lastRaw) {
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
        } else if (lastColumn && firstRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastColumn && lastRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
        } else if (firstColumn) {
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastColumn) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (firstRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
        } else {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        }
    }

    private void drawVertical(Canvas canvas, View view, int position, int spanCount, int childCount) {
        boolean firstRaw = this.isFirstRaw(1, position, spanCount, childCount);
        boolean lastRaw = this.isLastRaw(1, position, spanCount, childCount);
        boolean firstColumn = this.isFirstColumn(1, position, spanCount, childCount);
        boolean lastColumn = this.isLastColumn(1, position, spanCount, childCount);
        if (spanCount == 1) {
            if (!firstRaw || !lastRaw) {
                if (firstRaw) {
                    this.mDrawer.drawBottom(view, canvas);
                } else if (lastRaw) {
                    this.mDrawer.drawTop(view, canvas);
                } else {
                    this.mDrawer.drawTop(view, canvas);
                    this.mDrawer.drawBottom(view, canvas);
                }
            }
        } else if (firstRaw && firstColumn) {
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (firstRaw && lastColumn) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastRaw && firstColumn) {
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
        } else if (lastRaw && lastColumn) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
        } else if (firstRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastRaw) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
        } else if (firstColumn) {
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else if (lastColumn) {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        } else {
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        }
    }
}

