/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview.widget;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yanzhenjie.recyclerview.widget.ColorDrawer;
import com.yanzhenjie.recyclerview.widget.Drawer;

public class BorderItemDecoration
extends RecyclerView.ItemDecoration {
    private final int mWidth;
    private final int mHeight;
    private final Drawer mDrawer;

    public BorderItemDecoration(@ColorInt int color) {
        this(color, 4, 4);
    }

    public BorderItemDecoration(@ColorInt int color, int width, int height) {
        this.mWidth = Math.round((float)width / 2.0f);
        this.mHeight = Math.round((float)height / 2.0f);
        this.mDrawer = new ColorDrawer(color, this.mWidth, this.mHeight);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        outRect.set(this.mWidth, this.mHeight, this.mWidth, this.mHeight);
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        canvas.save();
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        assert (layoutManager != null);
        int childCount = layoutManager.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = layoutManager.getChildAt(i);
            this.mDrawer.drawLeft(view, canvas);
            this.mDrawer.drawTop(view, canvas);
            this.mDrawer.drawRight(view, canvas);
            this.mDrawer.drawBottom(view, canvas);
        }
        canvas.restore();
    }
}

