/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yanzhenjie.recyclerview.AdapterWrapper;
import com.yanzhenjie.recyclerview.OnItemClickListener;
import com.yanzhenjie.recyclerview.OnItemLongClickListener;
import com.yanzhenjie.recyclerview.OnItemMenuClickListener;
import com.yanzhenjie.recyclerview.SwipeMenuBridge;
import com.yanzhenjie.recyclerview.SwipeMenuCreator;
import com.yanzhenjie.recyclerview.SwipeMenuLayout;
import com.yanzhenjie.recyclerview.touch.DefaultItemTouchHelper;
import com.yanzhenjie.recyclerview.touch.OnItemMoveListener;
import com.yanzhenjie.recyclerview.touch.OnItemMovementListener;
import com.yanzhenjie.recyclerview.touch.OnItemStateChangedListener;
import com.yanzhenjie.recyclerview.widget.DefaultLoadMoreView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeRecyclerView
extends RecyclerView {
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = -1;
    private static final int INVALID_POSITION = -1;
    protected int mScaleTouchSlop;
    protected SwipeMenuLayout mOldSwipedLayout;
    protected int mOldTouchedPosition = -1;
    private int mDownX;
    private int mDownY;
    private boolean allowSwipeDelete;
    private DefaultItemTouchHelper mItemTouchHelper;
    private SwipeMenuCreator mSwipeMenuCreator;
    private OnItemMenuClickListener mOnItemMenuClickListener;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private AdapterWrapper mAdapterWrapper;
    private boolean mSwipeItemMenuEnable = true;
    private List<Integer> mDisableSwipeItemMenuList = new ArrayList<Integer>();
    private RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            SwipeRecyclerView.this.mAdapterWrapper.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            SwipeRecyclerView.this.mAdapterWrapper.notifyItemRangeChanged(positionStart += SwipeRecyclerView.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            SwipeRecyclerView.this.mAdapterWrapper.notifyItemRangeChanged(positionStart += SwipeRecyclerView.this.getHeaderCount(), itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            SwipeRecyclerView.this.mAdapterWrapper.notifyItemRangeInserted(positionStart += SwipeRecyclerView.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            SwipeRecyclerView.this.mAdapterWrapper.notifyItemRangeRemoved(positionStart += SwipeRecyclerView.this.getHeaderCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            SwipeRecyclerView.this.mAdapterWrapper.notifyItemMoved(fromPosition += SwipeRecyclerView.this.getHeaderCount(), toPosition += SwipeRecyclerView.this.getHeaderCount());
        }
    };
    private List<View> mHeaderViewList = new ArrayList<View>();
    private List<View> mFooterViewList = new ArrayList<View>();
    private int mScrollState = -1;
    private boolean isLoadMore = false;
    private boolean isAutoLoadMore = true;
    private boolean isLoadError = false;
    private boolean mDataEmpty = true;
    private boolean mHasMore = false;
    private LoadMoreView mLoadMoreView;
    private LoadMoreListener mLoadMoreListener;

    public SwipeRecyclerView(Context context) {
        this(context, null);
    }

    public SwipeRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mScaleTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            this.mItemTouchHelper = new DefaultItemTouchHelper();
            this.mItemTouchHelper.attachToRecyclerView(this);
        }
    }

    public void setOnItemMoveListener(OnItemMoveListener listener) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.setOnItemMoveListener(listener);
    }

    public void setOnItemMovementListener(OnItemMovementListener listener) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.setOnItemMovementListener(listener);
    }

    public void setOnItemStateChangedListener(OnItemStateChangedListener listener) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.setOnItemStateChangedListener(listener);
    }

    public void setSwipeItemMenuEnabled(boolean enabled) {
        this.mSwipeItemMenuEnable = enabled;
    }

    public boolean isSwipeItemMenuEnabled() {
        return this.mSwipeItemMenuEnable;
    }

    public void setSwipeItemMenuEnabled(int position, boolean enabled) {
        if (enabled) {
            if (this.mDisableSwipeItemMenuList.contains(position)) {
                this.mDisableSwipeItemMenuList.remove((Object)position);
            }
        } else if (!this.mDisableSwipeItemMenuList.contains(position)) {
            this.mDisableSwipeItemMenuList.add(position);
        }
    }

    public boolean isSwipeItemMenuEnabled(int position) {
        return !this.mDisableSwipeItemMenuList.contains(position);
    }

    public void setLongPressDragEnabled(boolean canDrag) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.setLongPressDragEnabled(canDrag);
    }

    public boolean isLongPressDragEnabled() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper.isLongPressDragEnabled();
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.initializeItemTouchHelper();
        this.allowSwipeDelete = canSwipe;
        this.mItemTouchHelper.setItemViewSwipeEnabled(canSwipe);
    }

    public boolean isItemViewSwipeEnabled() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper.isItemViewSwipeEnabled();
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.startDrag(viewHolder);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelper.startSwipe(viewHolder);
    }

    private void checkAdapterExist(String message) {
        if (this.mAdapterWrapper != null) {
            throw new IllegalStateException(message);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        if (listener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set item click listener, setAdapter has already been called.");
        this.mOnItemClickListener = new ItemClickListener(this, listener);
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (listener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set item long click listener, setAdapter has already been called.");
        this.mOnItemLongClickListener = new ItemLongClickListener(this, listener);
    }

    public void setSwipeMenuCreator(SwipeMenuCreator menuCreator) {
        if (menuCreator == null) {
            return;
        }
        this.checkAdapterExist("Cannot set menu creator, setAdapter has already been called.");
        this.mSwipeMenuCreator = menuCreator;
    }

    public void setOnItemMenuClickListener(OnItemMenuClickListener listener) {
        if (listener == null) {
            return;
        }
        this.checkAdapterExist("Cannot set menu item click listener, setAdapter has already been called.");
        this.mOnItemMenuClickListener = new ItemMenuClickListener(this, listener);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookupHolder = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (SwipeRecyclerView.this.mAdapterWrapper.isHeader(position) || SwipeRecyclerView.this.mAdapterWrapper.isFooter(position)) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (spanSizeLookupHolder != null) {
                        return spanSizeLookupHolder.getSpanSize(position - SwipeRecyclerView.this.getHeaderCount());
                    }
                    return 1;
                }
            });
        }
        super.setLayoutManager(layoutManager);
    }

    public RecyclerView.Adapter getOriginAdapter() {
        if (this.mAdapterWrapper == null) {
            return null;
        }
        return this.mAdapterWrapper.getOriginAdapter();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.getOriginAdapter().unregisterAdapterDataObserver(this.mAdapterDataObserver);
        }
        if (adapter == null) {
            this.mAdapterWrapper = null;
        } else {
            adapter.registerAdapterDataObserver(this.mAdapterDataObserver);
            this.mAdapterWrapper = new AdapterWrapper(this.getContext(), adapter);
            this.mAdapterWrapper.setOnItemClickListener(this.mOnItemClickListener);
            this.mAdapterWrapper.setOnItemLongClickListener(this.mOnItemLongClickListener);
            this.mAdapterWrapper.setSwipeMenuCreator(this.mSwipeMenuCreator);
            this.mAdapterWrapper.setOnItemMenuClickListener(this.mOnItemMenuClickListener);
            if (this.mHeaderViewList.size() > 0) {
                for (View view : this.mHeaderViewList) {
                    this.mAdapterWrapper.addHeaderView(view);
                }
            }
            if (this.mFooterViewList.size() > 0) {
                for (View view : this.mFooterViewList) {
                    this.mAdapterWrapper.addFooterView(view);
                }
            }
        }
        super.setAdapter((RecyclerView.Adapter)this.mAdapterWrapper);
    }

    public void addHeaderView(View view) {
        this.mHeaderViewList.add(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.addHeaderViewAndNotify(view);
        }
    }

    public void removeHeaderView(View view) {
        this.mHeaderViewList.remove(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.removeHeaderViewAndNotify(view);
        }
    }

    public void addFooterView(View view) {
        this.mFooterViewList.add(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.addFooterViewAndNotify(view);
        }
    }

    public void removeFooterView(View view) {
        this.mFooterViewList.remove(view);
        if (this.mAdapterWrapper != null) {
            this.mAdapterWrapper.removeFooterViewAndNotify(view);
        }
    }

    public int getHeaderCount() {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getHeaderCount();
    }

    public int getFooterCount() {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getFooterCount();
    }

    public int getItemViewType(int position) {
        if (this.mAdapterWrapper == null) {
            return 0;
        }
        return this.mAdapterWrapper.getItemViewType(position);
    }

    public void smoothOpenLeftMenu(int position) {
        this.smoothOpenMenu(position, 1, 200);
    }

    public void smoothOpenLeftMenu(int position, int duration) {
        this.smoothOpenMenu(position, 1, duration);
    }

    public void smoothOpenRightMenu(int position) {
        this.smoothOpenMenu(position, -1, 200);
    }

    public void smoothOpenRightMenu(int position, int duration) {
        this.smoothOpenMenu(position, -1, duration);
    }

    public void smoothOpenMenu(int position, int direction, int duration) {
        View itemView;
        RecyclerView.ViewHolder vh;
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
        if ((vh = this.findViewHolderForAdapterPosition(position += this.getHeaderCount())) != null && (itemView = this.getSwipeMenuView(vh.itemView)) instanceof SwipeMenuLayout) {
            this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
            if (direction == -1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenRightMenu(duration);
            } else if (direction == 1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenLeftMenu(duration);
            }
        }
    }

    public void smoothCloseMenu() {
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean touchMenuEnable;
        View itemView;
        boolean isIntercepted = super.onInterceptTouchEvent(e);
        if (this.allowSwipeDelete || this.mSwipeMenuCreator == null) {
            return isIntercepted;
        }
        if (e.getPointerCount() > 1) {
            return true;
        }
        int action = e.getAction();
        int x = (int)e.getX();
        int y = (int)e.getY();
        int touchPosition = this.getChildAdapterPosition(this.findChildViewUnder(x, y));
        RecyclerView.ViewHolder touchVH = this.findViewHolderForAdapterPosition(touchPosition);
        SwipeMenuLayout touchView = null;
        if (touchVH != null && (itemView = this.getSwipeMenuView(touchVH.itemView)) instanceof SwipeMenuLayout) {
            touchView = (SwipeMenuLayout)itemView;
        }
        boolean bl = touchMenuEnable = this.mSwipeItemMenuEnable && !this.mDisableSwipeItemMenuList.contains(touchPosition);
        if (touchView != null) {
            touchView.setSwipeEnable(touchMenuEnable);
        }
        if (!touchMenuEnable) {
            return isIntercepted;
        }
        switch (action) {
            case 0: {
                this.mDownX = x;
                this.mDownY = y;
                isIntercepted = false;
                if (touchPosition != this.mOldTouchedPosition && this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
                    this.mOldSwipedLayout.smoothCloseMenu();
                    isIntercepted = true;
                }
                if (isIntercepted) {
                    this.mOldSwipedLayout = null;
                    this.mOldTouchedPosition = -1;
                    break;
                }
                if (touchView == null) break;
                this.mOldSwipedLayout = touchView;
                this.mOldTouchedPosition = touchPosition;
                break;
            }
            case 2: {
                ViewParent viewParent;
                isIntercepted = this.handleUnDown(x, y, isIntercepted);
                if (this.mOldSwipedLayout == null || (viewParent = this.getParent()) == null) break;
                int disX = this.mDownX - x;
                boolean showRightCloseLeft = disX > 0 && (this.mOldSwipedLayout.hasRightMenu() || this.mOldSwipedLayout.isLeftCompleteOpen());
                boolean showLeftCloseRight = disX < 0 && (this.mOldSwipedLayout.hasLeftMenu() || this.mOldSwipedLayout.isRightCompleteOpen());
                viewParent.requestDisallowInterceptTouchEvent(showRightCloseLeft || showLeftCloseRight);
            }
            case 1: 
            case 3: {
                isIntercepted = this.handleUnDown(x, y, isIntercepted);
            }
        }
        return isIntercepted;
    }

    private boolean handleUnDown(int x, int y, boolean defaultValue) {
        int disX = this.mDownX - x;
        int disY = this.mDownY - y;
        if (Math.abs(disX) > this.mScaleTouchSlop && Math.abs(disX) > Math.abs(disY)) {
            return false;
        }
        if (Math.abs(disY) < this.mScaleTouchSlop && Math.abs(disX) < this.mScaleTouchSlop) {
            return false;
        }
        return defaultValue;
    }

    public boolean onTouchEvent(MotionEvent e) {
        int action = e.getAction();
        switch (action) {
            case 0: {
                break;
            }
            case 2: {
                if (this.mOldSwipedLayout == null || !this.mOldSwipedLayout.isMenuOpen()) break;
                this.mOldSwipedLayout.smoothCloseMenu();
                break;
            }
            case 1: {
                break;
            }
        }
        return super.onTouchEvent(e);
    }

    private View getSwipeMenuView(View itemView) {
        if (itemView instanceof SwipeMenuLayout) {
            return itemView;
        }
        ArrayList<View> unvisited = new ArrayList<View>();
        unvisited.add(itemView);
        while (!unvisited.isEmpty()) {
            View child = (View)unvisited.remove(0);
            if (!(child instanceof ViewGroup)) continue;
            if (child instanceof SwipeMenuLayout) {
                return child;
            }
            ViewGroup group = (ViewGroup)child;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                unvisited.add(group.getChildAt(i));
            }
        }
        return itemView;
    }

    public void onScrollStateChanged(int state) {
        this.mScrollState = state;
    }

    public void onScrolled(int dx, int dy) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int itemCount = layoutManager.getItemCount();
            if (itemCount <= 0) {
                return;
            }
            int lastVisiblePosition = linearLayoutManager.findLastVisibleItemPosition();
            if (itemCount == lastVisiblePosition + 1 && (this.mScrollState == 1 || this.mScrollState == 2)) {
                this.dispatchLoadMore();
            }
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            int itemCount = layoutManager.getItemCount();
            if (itemCount <= 0) {
                return;
            }
            int[] lastVisiblePositionArray = staggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(null);
            int lastVisiblePosition = lastVisiblePositionArray[lastVisiblePositionArray.length - 1];
            if (itemCount == lastVisiblePosition + 1 && (this.mScrollState == 1 || this.mScrollState == 2)) {
                this.dispatchLoadMore();
            }
        }
    }

    private void dispatchLoadMore() {
        if (this.isLoadError) {
            return;
        }
        if (!this.isAutoLoadMore) {
            if (this.mLoadMoreView != null) {
                this.mLoadMoreView.onWaitToLoadMore(this.mLoadMoreListener);
            }
        } else {
            if (this.isLoadMore || this.mDataEmpty || !this.mHasMore) {
                return;
            }
            this.isLoadMore = true;
            if (this.mLoadMoreView != null) {
                this.mLoadMoreView.onLoading();
            }
            if (this.mLoadMoreListener != null) {
                this.mLoadMoreListener.onLoadMore();
            }
        }
    }

    public void useDefaultLoadMore() {
        DefaultLoadMoreView defaultLoadMoreView = new DefaultLoadMoreView(this.getContext());
        this.addFooterView((View)defaultLoadMoreView);
        this.setLoadMoreView(defaultLoadMoreView);
    }

    public void setLoadMoreView(LoadMoreView view) {
        this.mLoadMoreView = view;
    }

    public void setLoadMoreListener(LoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setAutoLoadMore(boolean autoLoadMore) {
        this.isAutoLoadMore = autoLoadMore;
    }

    public final void loadMoreFinish(boolean dataEmpty, boolean hasMore) {
        this.isLoadMore = false;
        this.isLoadError = false;
        this.mDataEmpty = dataEmpty;
        this.mHasMore = hasMore;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.onLoadFinish(dataEmpty, hasMore);
        }
    }

    public void loadMoreError(int errorCode, String errorMessage) {
        this.isLoadMore = false;
        this.isLoadError = true;
        if (this.mLoadMoreView != null) {
            this.mLoadMoreView.onLoadError(errorCode, errorMessage);
        }
    }

    public static interface LoadMoreListener {
        public void onLoadMore();
    }

    public static interface LoadMoreView {
        public void onLoading();

        public void onLoadFinish(boolean var1, boolean var2);

        public void onWaitToLoadMore(LoadMoreListener var1);

        public void onLoadError(int var1, String var2);
    }

    private static class ItemMenuClickListener
    implements OnItemMenuClickListener {
        private SwipeRecyclerView mRecyclerView;
        private OnItemMenuClickListener mListener;

        public ItemMenuClickListener(SwipeRecyclerView recyclerView, OnItemMenuClickListener listener) {
            this.mRecyclerView = recyclerView;
            this.mListener = listener;
        }

        @Override
        public void onItemClick(SwipeMenuBridge menuBridge, int position) {
            if ((position -= this.mRecyclerView.getHeaderCount()) >= 0) {
                this.mListener.onItemClick(menuBridge, position);
            }
        }
    }

    private static class ItemLongClickListener
    implements OnItemLongClickListener {
        private SwipeRecyclerView mRecyclerView;
        private OnItemLongClickListener mListener;

        public ItemLongClickListener(SwipeRecyclerView recyclerView, OnItemLongClickListener listener) {
            this.mRecyclerView = recyclerView;
            this.mListener = listener;
        }

        @Override
        public void onItemLongClick(View itemView, int position) {
            if ((position -= this.mRecyclerView.getHeaderCount()) >= 0) {
                this.mListener.onItemLongClick(itemView, position);
            }
        }
    }

    private static class ItemClickListener
    implements OnItemClickListener {
        private SwipeRecyclerView mRecyclerView;
        private OnItemClickListener mListener;

        public ItemClickListener(SwipeRecyclerView recyclerView, OnItemClickListener listener) {
            this.mRecyclerView = recyclerView;
            this.mListener = listener;
        }

        @Override
        public void onItemClick(View itemView, int position) {
            if ((position -= this.mRecyclerView.getHeaderCount()) >= 0) {
                this.mListener.onItemClick(itemView, position);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DirectionMode {
    }
}

