/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.TextViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.yanzhenjie.recyclerview.Controller;
import com.yanzhenjie.recyclerview.OnItemMenuClickListener;
import com.yanzhenjie.recyclerview.SwipeMenu;
import com.yanzhenjie.recyclerview.SwipeMenuBridge;
import com.yanzhenjie.recyclerview.SwipeMenuItem;
import java.util.List;

public class SwipeMenuView
extends LinearLayout
implements View.OnClickListener {
    private RecyclerView.ViewHolder mViewHolder;
    private OnItemMenuClickListener mItemClickListener;

    public SwipeMenuView(Context context) {
        this(context, null);
    }

    public SwipeMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setGravity(16);
    }

    public void createMenu(RecyclerView.ViewHolder viewHolder, SwipeMenu swipeMenu, Controller controller, int direction, OnItemMenuClickListener itemClickListener) {
        this.removeAllViews();
        this.mViewHolder = viewHolder;
        this.mItemClickListener = itemClickListener;
        List<SwipeMenuItem> items = swipeMenu.getMenuItems();
        for (int i = 0; i < items.size(); ++i) {
            SwipeMenuItem item = items.get(i);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(item.getWidth(), item.getHeight());
            params.weight = item.getWeight();
            LinearLayout parent = new LinearLayout(this.getContext());
            parent.setId(i);
            parent.setGravity(17);
            parent.setOrientation(1);
            parent.setLayoutParams((ViewGroup.LayoutParams)params);
            ViewCompat.setBackground((View)parent, (Drawable)item.getBackground());
            parent.setOnClickListener((View.OnClickListener)this);
            this.addView((View)parent);
            SwipeMenuBridge menuBridge = new SwipeMenuBridge(controller, direction, i);
            parent.setTag((Object)menuBridge);
            if (item.getImage() != null) {
                ImageView iv = this.createIcon(item);
                parent.addView((View)iv);
            }
            if (TextUtils.isEmpty((CharSequence)item.getText())) continue;
            TextView tv = this.createTitle(item);
            parent.addView((View)tv);
        }
    }

    public void onClick(View v) {
        if (this.mItemClickListener != null) {
            this.mItemClickListener.onItemClick((SwipeMenuBridge)v.getTag(), this.mViewHolder.getAdapterPosition());
        }
    }

    private ImageView createIcon(SwipeMenuItem item) {
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(item.getImage());
        return imageView;
    }

    private TextView createTitle(SwipeMenuItem item) {
        Typeface typeface;
        int textAppearance;
        ColorStateList textColor;
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)item.getText());
        textView.setGravity(17);
        int textSize = item.getTextSize();
        if (textSize > 0) {
            textView.setTextSize(2, (float)textSize);
        }
        if ((textColor = item.getTitleColor()) != null) {
            textView.setTextColor(textColor);
        }
        if ((textAppearance = item.getTextAppearance()) != 0) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)textAppearance);
        }
        if ((typeface = item.getTextTypeface()) != null) {
            textView.setTypeface(typeface);
        }
        return textView;
    }
}

