/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.core.content.ContextCompat;

public class SwipeMenuItem {
    private Context mContext;
    private Drawable background;
    private Drawable icon;
    private String title;
    private ColorStateList titleColor;
    private int titleSize;
    private Typeface textTypeface;
    private int textAppearance;
    private int width = -2;
    private int height = -2;
    private int weight = 0;

    public SwipeMenuItem(Context context) {
        this.mContext = context;
    }

    public SwipeMenuItem setBackground(@DrawableRes int resId) {
        return this.setBackground(ContextCompat.getDrawable((Context)this.mContext, (int)resId));
    }

    public SwipeMenuItem setBackground(Drawable background) {
        this.background = background;
        return this;
    }

    public SwipeMenuItem setBackgroundColorResource(@ColorRes int color) {
        return this.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)color));
    }

    public SwipeMenuItem setBackgroundColor(@ColorInt int color) {
        this.background = new ColorDrawable(color);
        return this;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public SwipeMenuItem setImage(@DrawableRes int resId) {
        return this.setImage(ContextCompat.getDrawable((Context)this.mContext, (int)resId));
    }

    public SwipeMenuItem setImage(Drawable icon) {
        this.icon = icon;
        return this;
    }

    public Drawable getImage() {
        return this.icon;
    }

    public SwipeMenuItem setText(@StringRes int resId) {
        return this.setText(this.mContext.getString(resId));
    }

    public SwipeMenuItem setText(String title) {
        this.title = title;
        return this;
    }

    public String getText() {
        return this.title;
    }

    public SwipeMenuItem setTextColorResource(@ColorRes int titleColor) {
        return this.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)titleColor));
    }

    public SwipeMenuItem setTextColor(@ColorInt int titleColor) {
        this.titleColor = ColorStateList.valueOf((int)titleColor);
        return this;
    }

    public ColorStateList getTitleColor() {
        return this.titleColor;
    }

    public SwipeMenuItem setTextSize(int titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    public int getTextSize() {
        return this.titleSize;
    }

    public SwipeMenuItem setTextAppearance(@StyleRes int textAppearance) {
        this.textAppearance = textAppearance;
        return this;
    }

    public int getTextAppearance() {
        return this.textAppearance;
    }

    public SwipeMenuItem setTextTypeface(Typeface textTypeface) {
        this.textTypeface = textTypeface;
        return this;
    }

    public Typeface getTextTypeface() {
        return this.textTypeface;
    }

    public SwipeMenuItem setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public SwipeMenuItem setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public SwipeMenuItem setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }
}

