/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.yanzhenjie.recyclerview.SwipeMenuItem;
import com.yanzhenjie.recyclerview.SwipeMenuLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenu {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private SwipeMenuLayout mMenuLayout;
    private int mOrientation;
    private List<SwipeMenuItem> mSwipeMenuItems;

    public SwipeMenu(SwipeMenuLayout menuLayout) {
        this.mMenuLayout = menuLayout;
        this.mOrientation = 0;
        this.mSwipeMenuItems = new ArrayList<SwipeMenuItem>(2);
    }

    public void setOpenPercent(@FloatRange(from=0.1, to=1.0) float openPercent) {
        this.mMenuLayout.setOpenPercent(openPercent);
    }

    public void setScrollerDuration(@IntRange(from=1L) int scrollerDuration) {
        this.mMenuLayout.setScrollerDuration(scrollerDuration);
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void addMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.add(item);
    }

    public void removeMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.remove(item);
    }

    public List<SwipeMenuItem> getMenuItems() {
        return this.mSwipeMenuItems;
    }

    public boolean hasMenuItems() {
        return !this.mSwipeMenuItems.isEmpty();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

