/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.view.View;
import android.widget.OverScroller;
import com.yanzhenjie.recyclerview.Horizontal;

class RightHorizontal
extends Horizontal {
    public RightHorizontal(View menuView) {
        super(-1, menuView);
    }

    @Override
    public boolean isMenuOpen(int scrollX) {
        int i = -this.getMenuView().getWidth() * this.getDirection();
        return scrollX >= i && i != 0;
    }

    @Override
    public boolean isMenuOpenNotEqual(int scrollX) {
        return scrollX > -this.getMenuView().getWidth() * this.getDirection();
    }

    @Override
    public void autoOpenMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(Math.abs(scrollX), 0, this.getMenuView().getWidth() - Math.abs(scrollX), 0, duration);
    }

    @Override
    public void autoCloseMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(-Math.abs(scrollX), 0, Math.abs(scrollX), 0, duration);
    }

    @Override
    public Horizontal.Checker checkXY(int x, int y) {
        this.mChecker.x = x;
        this.mChecker.y = y;
        this.mChecker.shouldResetSwipe = false;
        if (this.mChecker.x == 0) {
            this.mChecker.shouldResetSwipe = true;
        }
        if (this.mChecker.x < 0) {
            this.mChecker.x = 0;
        }
        if (this.mChecker.x > this.getMenuView().getWidth()) {
            this.mChecker.x = this.getMenuView().getWidth();
        }
        return this.mChecker;
    }

    @Override
    public boolean isClickOnContentView(int contentViewWidth, float x) {
        return x < (float)(contentViewWidth - this.getMenuView().getWidth());
    }
}

