/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class ExpandableAdapter<VH extends ViewHolder>
extends RecyclerView.Adapter<VH> {
    private static final int TYPE_PARENT = 1;
    private static final int TYPE_CHILD = 2;
    private final SparseBooleanArray mExpandItemArray = new SparseBooleanArray();
    private final List<Integer> mParentViewType = new ArrayList<Integer>();

    public final boolean isExpanded(int parentPosition) {
        return this.mExpandItemArray.get(parentPosition, false);
    }

    public final void expandParent(int parentPosition) {
        if (!this.isExpanded(parentPosition)) {
            this.mExpandItemArray.append(parentPosition, true);
            int position = this.positionFromParentPosition(parentPosition);
            int childCount = this.childItemCount(parentPosition);
            this.notifyItemRangeInserted(position + 1, childCount);
        }
    }

    public final void collapseParent(int parentPosition) {
        if (this.isExpanded(parentPosition)) {
            this.mExpandItemArray.append(parentPosition, false);
            int position = this.positionFromParentPosition(parentPosition);
            int childCount = this.childItemCount(parentPosition);
            this.notifyItemRangeRemoved(position + 1, childCount);
        }
    }

    public final void notifyParentChanged(int parentPosition) {
        int position = this.positionFromParentPosition(parentPosition);
        this.notifyItemChanged(position);
    }

    public final void notifyParentInserted(int parentPosition) {
        int position = this.positionFromParentPosition(parentPosition);
        this.notifyItemInserted(position);
    }

    public final void notifyParentRemoved(int parentPosition) {
        int position = this.positionFromParentPosition(parentPosition);
        this.notifyItemRemoved(position);
    }

    public final void notifyChildChanged(int parentPosition, int childPosition) {
        int position = this.positionFromChildPosition(parentPosition, childPosition);
        this.notifyItemChanged(position);
    }

    public final void notifyChildInserted(int parentPosition, int childPosition) {
        int position = this.positionFromChildPosition(parentPosition, childPosition);
        this.notifyItemInserted(position);
    }

    public final void notifyChildRemoved(int parentPosition, int childPosition) {
        int position = this.positionFromChildPosition(parentPosition, childPosition);
        this.notifyItemRemoved(position);
    }

    private int positionFromParentPosition(int parentPosition) {
        int itemCount = 0;
        int parentCount = this.parentItemCount();
        for (int i = 0; i < parentCount; ++i) {
            ++itemCount;
            if (parentPosition == i) {
                return itemCount - 1;
            }
            if (!this.isExpanded(i)) continue;
            itemCount += this.childItemCount(i);
        }
        throw new IllegalStateException("The parent position is invalid: " + parentPosition);
    }

    private int positionFromChildPosition(int parentPosition, int childPosition) {
        int itemCount = 0;
        int parentCount = this.parentItemCount();
        for (int i = 0; i < parentCount; ++i) {
            ++itemCount;
            if (parentPosition == i) {
                int childCount = this.childItemCount(parentPosition);
                if (childPosition < childCount) {
                    return (itemCount += childPosition + 1) - 1;
                }
                throw new IllegalStateException("The child position is invalid: " + childPosition);
            }
            if (!this.isExpanded(i)) continue;
            itemCount += this.childItemCount(i);
        }
        throw new IllegalStateException("The parent position is invalid: " + parentPosition);
    }

    public final int getItemCount() {
        int parentCount = this.parentItemCount();
        for (int i = 0; i < parentCount; ++i) {
            if (!this.isExpanded(i)) continue;
            int childCount = this.childItemCount(i);
            parentCount += childCount;
        }
        return parentCount;
    }

    public abstract int parentItemCount();

    public abstract int childItemCount(int var1);

    public final int getItemViewType(int position) {
        int parentPosition = this.parentItemPosition(position);
        if (this.isParentItem(position)) {
            int viewType = this.parentItemViewType(parentPosition);
            this.checkViewType(viewType);
            if (!this.mParentViewType.contains(viewType)) {
                this.mParentViewType.add(viewType);
            }
            return viewType;
        }
        int childPosition = this.childItemPosition(position);
        int viewType = this.childItemViewType(parentPosition, childPosition);
        this.checkViewType(viewType);
        return viewType;
    }

    private void checkViewType(int type) {
        if (type == 1 || type == 2) {
            String message = String.format(Locale.US, "The value [%d] is reserved, please replace it with other values.", type);
            throw new IllegalArgumentException(message);
        }
    }

    public int parentItemViewType(int parentPosition) {
        return 1;
    }

    public int childItemViewType(int parentPosition, int childPosition) {
        return 2;
    }

    public final boolean isParentItem(int adapterPosition) {
        int itemCount = 0;
        int parentCount = this.parentItemCount();
        for (int i = 0; i < parentCount; ++i) {
            if (itemCount == adapterPosition) {
                return true;
            }
            ++itemCount;
            if (!this.isExpanded(i)) continue;
            itemCount += this.childItemCount(i);
        }
        return false;
    }

    public final int parentItemPosition(int adapterPosition) {
        int itemCount = 0;
        for (int i = 0; i < this.parentItemCount(); ++i) {
            ++itemCount;
            if (this.isExpanded(i)) {
                int childCount = this.childItemCount(i);
                itemCount += childCount;
            }
            if (adapterPosition >= itemCount) continue;
            return i;
        }
        throw new IllegalStateException("The adapter position is not a parent type: " + adapterPosition);
    }

    public final int childItemPosition(int childAdapterPosition) {
        int itemCount = 0;
        int parentCount = this.parentItemCount();
        for (int i = 0; i < parentCount; ++i) {
            int childCount;
            ++itemCount;
            if (!this.isExpanded(i) || childAdapterPosition >= (itemCount += (childCount = this.childItemCount(i)))) continue;
            return childCount - (itemCount - childAdapterPosition);
        }
        throw new IllegalStateException("The adapter position is invalid: " + childAdapterPosition);
    }

    @NonNull
    public final VH onCreateViewHolder(@NonNull ViewGroup root, int viewType) {
        if (this.mParentViewType.contains(viewType)) {
            return this.createParentHolder(root, viewType);
        }
        return this.createChildHolder(root, viewType);
    }

    public abstract VH createParentHolder(@NonNull ViewGroup var1, int var2);

    public abstract VH createChildHolder(@NonNull ViewGroup var1, int var2);

    public final void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads) {
        int parentPosition = this.parentItemPosition(position);
        if (this.isParentItem(position)) {
            this.bindParentHolder(holder, parentPosition, payloads);
        } else {
            int childPosition = this.childItemPosition(position);
            this.bindChildHolder(holder, parentPosition, childPosition, payloads);
        }
    }

    public void bindParentHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads) {
        this.bindParentHolder(holder, position);
    }

    public void bindChildHolder(@NonNull VH holder, int parentPosition, int position, @NonNull List<Object> payloads) {
        this.bindChildHolder(holder, parentPosition, position);
    }

    public abstract void bindParentHolder(@NonNull VH var1, int var2);

    public abstract void bindChildHolder(@NonNull VH var1, int var2, int var3);

    @Deprecated
    public final void onBindViewHolder(@NonNull VH holder, int position) {
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        RecyclerView.LayoutManager lm = recyclerView.getLayoutManager();
        if (lm instanceof GridLayoutManager) {
            final GridLayoutManager glm = (GridLayoutManager)lm;
            final GridLayoutManager.SpanSizeLookup originLookup = glm.getSpanSizeLookup();
            glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (ExpandableAdapter.this.isParentItem(position)) {
                        return glm.getSpanCount();
                    }
                    if (originLookup != null) {
                        return originLookup.getSpanSize(position);
                    }
                    return 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(@NonNull VH holder) {
        ViewGroup.LayoutParams lp;
        if (this.isParentItem(holder.getAdapterPosition()) && (lp = ((ViewHolder)((Object)holder)).itemView.getLayoutParams()) instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    public static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        private ExpandableAdapter mAdapter;

        public ViewHolder(@NonNull View itemView, ExpandableAdapter adapter) {
            super(itemView);
            this.mAdapter = adapter;
        }

        public final boolean isParentItem() {
            return this.mAdapter.isParentItem(this.getAdapterPosition());
        }

        public final int parentItemPosition() {
            return this.mAdapter.parentItemPosition(this.getAdapterPosition());
        }

        public final int childItemPosition() {
            if (this.isParentItem()) {
                throw new IllegalStateException("This item is not a child item.");
            }
            return this.mAdapter.childItemPosition(this.getAdapterPosition());
        }

        public final boolean isParentExpanded() {
            return this.mAdapter.isExpanded(this.parentItemPosition());
        }
    }
}

