/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.recyclerview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.SparseArrayCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.yanzhenjie.recyclerview.OnItemClickListener;
import com.yanzhenjie.recyclerview.OnItemLongClickListener;
import com.yanzhenjie.recyclerview.OnItemMenuClickListener;
import com.yanzhenjie.recyclerview.SwipeMenu;
import com.yanzhenjie.recyclerview.SwipeMenuCreator;
import com.yanzhenjie.recyclerview.SwipeMenuLayout;
import com.yanzhenjie.recyclerview.SwipeMenuView;
import com.yanzhenjie.recyclerview.x.R;
import java.lang.reflect.Field;
import java.util.List;

class AdapterWrapper
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int BASE_ITEM_TYPE_HEADER = 100000;
    private static final int BASE_ITEM_TYPE_FOOTER = 200000;
    private SparseArrayCompat<View> mHeaderViews = new SparseArrayCompat();
    private SparseArrayCompat<View> mFootViews = new SparseArrayCompat();
    private RecyclerView.Adapter mAdapter;
    private LayoutInflater mInflater;
    private SwipeMenuCreator mSwipeMenuCreator;
    private OnItemMenuClickListener mOnItemMenuClickListener;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;

    AdapterWrapper(Context context, RecyclerView.Adapter adapter) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mAdapter = adapter;
    }

    public RecyclerView.Adapter getOriginAdapter() {
        return this.mAdapter;
    }

    void setSwipeMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
    }

    void setOnItemMenuClickListener(OnItemMenuClickListener onItemMenuClickListener) {
        this.mOnItemMenuClickListener = onItemMenuClickListener;
    }

    void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public int getItemCount() {
        return this.getHeaderCount() + this.getContentItemCount() + this.getFooterCount();
    }

    private int getContentItemCount() {
        return this.mAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (this.isHeader(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        if (this.isFooter(position)) {
            return this.mFootViews.keyAt(position - this.getHeaderCount() - this.getContentItemCount());
        }
        return this.mAdapter.getItemViewType(position - this.getHeaderCount());
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View contentView = (View)this.mHeaderViews.get(viewType);
        if (contentView != null) {
            return new ViewHolder(contentView);
        }
        contentView = (View)this.mFootViews.get(viewType);
        if (contentView != null) {
            return new ViewHolder(contentView);
        }
        final RecyclerView.ViewHolder viewHolder = this.mAdapter.onCreateViewHolder(parent, viewType);
        if (this.mOnItemClickListener != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AdapterWrapper.this.mOnItemClickListener.onItemClick(v, viewHolder.getAdapterPosition());
                }
            });
        }
        if (this.mOnItemLongClickListener != null) {
            viewHolder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AdapterWrapper.this.mOnItemLongClickListener.onItemLongClick(v, viewHolder.getAdapterPosition());
                    return true;
                }
            });
        }
        if (this.mSwipeMenuCreator == null) {
            return viewHolder;
        }
        contentView = this.mInflater.inflate(R.layout.x_recycler_view_item, parent, false);
        ViewGroup viewGroup = (ViewGroup)contentView.findViewById(R.id.swipe_content);
        viewGroup.addView(viewHolder.itemView);
        try {
            Field itemView = this.getSupperClass(viewHolder.getClass()).getDeclaredField("itemView");
            if (!itemView.isAccessible()) {
                itemView.setAccessible(true);
            }
            itemView.set(viewHolder, contentView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewHolder;
    }

    private Class<?> getSupperClass(Class<?> aClass) {
        Class<?> supperClass = aClass.getSuperclass();
        if (supperClass != null && !supperClass.equals(Object.class)) {
            return this.getSupperClass(supperClass);
        }
        return aClass;
    }

    public final void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
    }

    public final void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (this.isHeaderOrFooter(holder)) {
            return;
        }
        View itemView = holder.itemView;
        position -= this.getHeaderCount();
        if (itemView instanceof SwipeMenuLayout && this.mSwipeMenuCreator != null) {
            SwipeMenuLayout menuLayout = (SwipeMenuLayout)itemView;
            SwipeMenu leftMenu = new SwipeMenu(menuLayout);
            SwipeMenu rightMenu = new SwipeMenu(menuLayout);
            this.mSwipeMenuCreator.onCreateMenu(leftMenu, rightMenu, position);
            SwipeMenuView leftMenuView = (SwipeMenuView)menuLayout.getChildAt(0);
            if (leftMenu.hasMenuItems()) {
                leftMenuView.setOrientation(leftMenu.getOrientation());
                leftMenuView.createMenu(holder, leftMenu, menuLayout, 1, this.mOnItemMenuClickListener);
            } else if (leftMenuView.getChildCount() > 0) {
                leftMenuView.removeAllViews();
            }
            SwipeMenuView rightMenuView = (SwipeMenuView)menuLayout.getChildAt(2);
            if (rightMenu.hasMenuItems()) {
                rightMenuView.setOrientation(rightMenu.getOrientation());
                rightMenuView.createMenu(holder, rightMenu, menuLayout, -1, this.mOnItemMenuClickListener);
            } else if (rightMenuView.getChildCount() > 0) {
                rightMenuView.removeAllViews();
            }
        }
        this.mAdapter.onBindViewHolder(holder, position, payloads);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mAdapter.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager lm = recyclerView.getLayoutManager();
        if (lm instanceof GridLayoutManager) {
            final GridLayoutManager glm = (GridLayoutManager)lm;
            final GridLayoutManager.SpanSizeLookup originLookup = glm.getSpanSizeLookup();
            glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (AdapterWrapper.this.isHeaderOrFooter(position)) {
                        return glm.getSpanCount();
                    }
                    if (originLookup != null) {
                        return originLookup.getSpanSize(position);
                    }
                    return 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        if (this.isHeaderOrFooter(holder)) {
            ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
            if (lp instanceof StaggeredGridLayoutManager.LayoutParams) {
                StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
                p.setFullSpan(true);
            }
        } else {
            this.mAdapter.onViewAttachedToWindow(holder);
        }
    }

    public boolean isHeaderOrFooter(RecyclerView.ViewHolder holder) {
        if (holder instanceof ViewHolder) {
            return true;
        }
        return this.isHeaderOrFooter(holder.getAdapterPosition());
    }

    public boolean isHeaderOrFooter(int position) {
        return this.isHeader(position) || this.isFooter(position);
    }

    public boolean isHeader(int position) {
        return position >= 0 && position < this.getHeaderCount();
    }

    public boolean isFooter(int position) {
        return position >= this.getHeaderCount() + this.getContentItemCount();
    }

    public void addHeaderView(View view) {
        this.mHeaderViews.put(this.getHeaderCount() + 100000, (Object)view);
    }

    public void addHeaderViewAndNotify(View view) {
        this.addHeaderView(view);
        this.notifyItemInserted(this.getHeaderCount() - 1);
    }

    public void removeHeaderViewAndNotify(View view) {
        int headerIndex = this.mHeaderViews.indexOfValue((Object)view);
        if (headerIndex == -1) {
            return;
        }
        this.mHeaderViews.removeAt(headerIndex);
        this.notifyItemRemoved(headerIndex);
    }

    public void addFooterView(View view) {
        this.mFootViews.put(this.getFooterCount() + 200000, (Object)view);
    }

    public void addFooterViewAndNotify(View view) {
        this.addFooterView(view);
        this.notifyItemInserted(this.getHeaderCount() + this.getContentItemCount() + this.getFooterCount() - 1);
    }

    public void removeFooterViewAndNotify(View view) {
        int footerIndex = this.mFootViews.indexOfValue((Object)view);
        if (footerIndex == -1) {
            return;
        }
        this.mFootViews.removeAt(footerIndex);
        this.notifyItemRemoved(this.getHeaderCount() + this.getContentItemCount() + footerIndex);
    }

    public int getHeaderCount() {
        return this.mHeaderViews.size();
    }

    public int getFooterCount() {
        return this.mFootViews.size();
    }

    public final void setHasStableIds(boolean hasStableIds) {
        super.setHasStableIds(hasStableIds);
    }

    public long getItemId(int position) {
        if (this.isHeaderOrFooter(position)) {
            return -position - 1;
        }
        return this.mAdapter.getItemId(position -= this.getHeaderCount());
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        if (!this.isHeaderOrFooter(holder)) {
            this.mAdapter.onViewRecycled(holder);
        }
    }

    public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
        if (!this.isHeaderOrFooter(holder)) {
            return this.mAdapter.onFailedToRecycleView(holder);
        }
        return false;
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        if (!this.isHeaderOrFooter(holder)) {
            this.mAdapter.onViewDetachedFromWindow(holder);
        }
    }

    public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.registerAdapterDataObserver(observer);
    }

    public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
        super.unregisterAdapterDataObserver(observer);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

