/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.source;

import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class Source {
    private static final int MODE_ASK = 4;
    private static final String CHECK_OP_NO_THROW = "checkOpNoThrow";
    private static final String OP_REQUEST_INSTALL_PACKAGES = "OP_REQUEST_INSTALL_PACKAGES";
    private static final String OP_SYSTEM_ALERT_WINDOW = "OP_SYSTEM_ALERT_WINDOW";
    private static final String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
    private static final String OP_ACCESS_NOTIFICATIONS = "OP_ACCESS_NOTIFICATIONS";
    private static final String OP_WRITE_SETTINGS = "OP_WRITE_SETTINGS";
    private int mTargetSdkVersion;
    private String mPackageName;
    private PackageManager mPackageManager;
    private AppOpsManager mAppOpsManager;
    private NotificationManager mNotificationManager;

    public abstract Context getContext();

    public abstract void startActivity(Intent var1);

    public abstract void startActivityForResult(Intent var1, int var2);

    public abstract boolean isShowRationalePermission(String var1);

    private int getTargetSdkVersion() {
        if (this.mTargetSdkVersion < 14) {
            this.mTargetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
        }
        return this.mTargetSdkVersion;
    }

    public String getPackageName() {
        if (this.mPackageName == null) {
            this.mPackageName = this.getContext().getApplicationContext().getPackageName();
        }
        return this.mPackageName;
    }

    private PackageManager getPackageManager() {
        if (this.mPackageManager == null) {
            this.mPackageManager = this.getContext().getPackageManager();
        }
        return this.mPackageManager;
    }

    @RequiresApi(api=19)
    private AppOpsManager getAppOpsManager() {
        if (this.mAppOpsManager == null) {
            this.mAppOpsManager = (AppOpsManager)this.getContext().getSystemService("appops");
        }
        return this.mAppOpsManager;
    }

    private NotificationManager getNotificationManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.getContext().getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    public final boolean canRequestPackageInstalls() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.getTargetSdkVersion() < 26) {
                return this.reflectionOps(OP_REQUEST_INSTALL_PACKAGES);
            }
            return this.getPackageManager().canRequestPackageInstalls();
        }
        return true;
    }

    public final boolean canDrawOverlays() {
        if (Build.VERSION.SDK_INT >= 23) {
            Context context = this.getContext();
            if (this.getTargetSdkVersion() >= 23) {
                return Settings.canDrawOverlays((Context)context);
            }
            return this.reflectionOps(OP_SYSTEM_ALERT_WINDOW);
        }
        return true;
    }

    public final boolean canNotify() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.getNotificationManager().areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return this.reflectionOps(OP_POST_NOTIFICATION);
        }
        return true;
    }

    @RequiresApi(api=18)
    public final boolean canListenerNotification() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.reflectionOps(OP_ACCESS_NOTIFICATIONS);
        }
        Context context = this.getContext();
        String flat = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"enabled_notification_listeners");
        return flat != null && flat.contains(this.getPackageName());
    }

    public final boolean canWriteSetting() {
        if (Build.VERSION.SDK_INT >= 23) {
            Context context = this.getContext();
            if (this.getTargetSdkVersion() >= 23) {
                return Settings.System.canWrite((Context)context);
            }
            return this.reflectionOps(OP_WRITE_SETTINGS);
        }
        return true;
    }

    @RequiresApi(api=19)
    private boolean reflectionOps(String opFieldName) {
        int uid = this.getContext().getApplicationInfo().uid;
        try {
            Class<AppOpsManager> appOpsClass = AppOpsManager.class;
            Method method = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opField = appOpsClass.getDeclaredField(opFieldName);
            int opValue = (Integer)opField.get(Integer.class);
            int result = (Integer)method.invoke((Object)this.getAppOpsManager(), opValue, uid, this.getPackageName());
            return result == 0 || result == 4;
        }
        catch (Throwable e) {
            return true;
        }
    }
}

