/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.source;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;
import java.lang.reflect.Method;

public class ContextSource
extends Source {
    private Context mContext;

    public ContextSource(Context context) {
        this.mContext = context;
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void startActivity(Intent intent) {
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public boolean isShowRationalePermission(String permission) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Class<?> pkManagerClass = packageManager.getClass();
        try {
            Method method = pkManagerClass.getMethod("shouldShowRequestPermissionRationale", String.class);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Boolean)method.invoke((Object)packageManager, permission);
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

