/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime.setting;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;

public class SettingPage {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public SettingPage(Source source) {
        this.mSource = source;
    }

    public void start(int requestCode) {
        Intent intent = MARK.contains("huawei") ? SettingPage.huaweiApi(this.mSource.getContext()) : (MARK.contains("xiaomi") ? SettingPage.xiaomiApi(this.mSource.getContext()) : (MARK.contains("oppo") ? SettingPage.oppoApi(this.mSource.getContext()) : (MARK.contains("vivo") ? SettingPage.vivoApi(this.mSource.getContext()) : (MARK.contains("meizu") ? SettingPage.meizuApi(this.mSource.getContext()) : SettingPage.defaultApi(this.mSource.getContext())))));
        try {
            this.mSource.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            intent = SettingPage.defaultApi(this.mSource.getContext());
            this.mSource.startActivityForResult(intent, requestCode);
        }
    }

    private static Intent defaultApi(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private static Intent huaweiApi(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return SettingPage.defaultApi(context);
    }

    private static Intent xiaomiApi(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.putExtra("extra_pkgname", context.getPackageName());
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return SettingPage.defaultApi(context);
    }

    private static Intent vivoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packagename", context.getPackageName());
        intent.setClassName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.SoftPermissionDetailActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.iqoo.secure", "com.iqoo.secure.safeguard.SoftPermissionDetailActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return SettingPage.defaultApi(context);
    }

    private static Intent oppoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packageName", context.getPackageName());
        intent.setClassName("com.color.safecenter", "com.color.safecenter.permission.PermissionManagerActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.oppo.safe", "com.oppo.safe.permission.PermissionAppListActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return SettingPage.defaultApi(context);
    }

    private static Intent meizuApi(Context context) {
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setClassName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity");
        if (SettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return SettingPage.defaultApi(context);
    }

    private static boolean hasActivity(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }
}

