/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.yanzhenjie.permission.runtime.LRequestFactory;
import com.yanzhenjie.permission.runtime.MRequestFactory;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.runtime.option.RuntimeOption;
import com.yanzhenjie.permission.runtime.setting.AllRequest;
import com.yanzhenjie.permission.runtime.setting.SettingRequest;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Runtime
implements RuntimeOption {
    private static final PermissionRequestFactory FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();
    private static List<String> sAppPermissions;
    private Source mSource;

    public Runtime(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission(String ... permissions) {
        this.checkPermissions(permissions);
        return FACTORY.create(this.mSource).permission(permissions);
    }

    @Override
    public PermissionRequest permission(String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : groups) {
            this.checkPermissions(group);
            permissionList.addAll(Arrays.asList(group));
        }
        String[] permissions = permissionList.toArray(new String[0]);
        return this.permission(permissions);
    }

    @Override
    public SettingRequest setting() {
        return new AllRequest(this.mSource);
    }

    private void checkPermissions(String ... permissions) {
        if (sAppPermissions == null) {
            sAppPermissions = Runtime.getManifestPermissions(this.mSource.getContext());
        }
        if (permissions.length == 0) {
            throw new IllegalArgumentException("Please enter at least one permission.");
        }
        for (String p : permissions) {
            if (sAppPermissions.contains(p) || "com.android.voicemail.permission.ADD_VOICEMAIL".equals(p) && sAppPermissions.contains("android.permission.ADD_VOICEMAIL")) continue;
            throw new IllegalStateException(String.format("The permission %1$s is not registered in manifest.xml", p));
        }
    }

    private static List<String> getManifestPermissions(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            String[] permissions = packageInfo.requestedPermissions;
            if (permissions == null || permissions.length == 0) {
                throw new IllegalStateException("You did not register any permissions in the manifest.xml.");
            }
            return Collections.unmodifiableList(Arrays.asList(permissions));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new AssertionError((Object)"Package name cannot be found.");
        }
    }

    public static interface PermissionRequestFactory {
        public PermissionRequest create(Source var1);
    }
}

