/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.content.Context;
import android.os.Build;
import com.yanzhenjie.permission.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Permission {
    public static final String READ_CALENDAR = "android.permission.READ_CALENDAR";
    public static final String WRITE_CALENDAR = "android.permission.WRITE_CALENDAR";
    public static final String CAMERA = "android.permission.CAMERA";
    public static final String READ_CONTACTS = "android.permission.READ_CONTACTS";
    public static final String WRITE_CONTACTS = "android.permission.WRITE_CONTACTS";
    public static final String GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    public static final String ACCESS_FINE_LOCATION = "android.permission.ACCESS_FINE_LOCATION";
    public static final String ACCESS_COARSE_LOCATION = "android.permission.ACCESS_COARSE_LOCATION";
    public static final String RECORD_AUDIO = "android.permission.RECORD_AUDIO";
    public static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    public static final String CALL_PHONE = "android.permission.CALL_PHONE";
    public static final String READ_CALL_LOG = "android.permission.READ_CALL_LOG";
    public static final String WRITE_CALL_LOG = "android.permission.WRITE_CALL_LOG";
    public static final String ADD_VOICEMAIL = "com.android.voicemail.permission.ADD_VOICEMAIL";
    static final String ADD_VOICEMAIL_MANIFEST = "android.permission.ADD_VOICEMAIL";
    public static final String USE_SIP = "android.permission.USE_SIP";
    public static final String PROCESS_OUTGOING_CALLS = "android.permission.PROCESS_OUTGOING_CALLS";
    public static final String READ_PHONE_NUMBERS = "android.permission.READ_PHONE_NUMBERS";
    public static final String ANSWER_PHONE_CALLS = "android.permission.ANSWER_PHONE_CALLS";
    public static final String BODY_SENSORS = "android.permission.BODY_SENSORS";
    public static final String SEND_SMS = "android.permission.SEND_SMS";
    public static final String RECEIVE_SMS = "android.permission.RECEIVE_SMS";
    public static final String READ_SMS = "android.permission.READ_SMS";
    public static final String RECEIVE_WAP_PUSH = "android.permission.RECEIVE_WAP_PUSH";
    public static final String RECEIVE_MMS = "android.permission.RECEIVE_MMS";
    public static final String READ_EXTERNAL_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    public static final String WRITE_EXTERNAL_STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";

    public static List<String> transformText(Context context, String ... permissions) {
        return Permission.transformText(context, Arrays.asList(permissions));
    }

    public static List<String> transformText(Context context, String[] ... groups) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (String[] group : groups) {
            permissionList.addAll(Arrays.asList(group));
        }
        return Permission.transformText(context, permissionList);
    }

    public static List<String> transformText(Context context, List<String> permissions) {
        ArrayList<String> textList = new ArrayList<String>();
        Iterator<String> iterator = permissions.iterator();
        while (iterator.hasNext()) {
            String permission;
            switch (permission = iterator.next()) {
                case "android.permission.READ_CALENDAR": 
                case "android.permission.WRITE_CALENDAR": {
                    String message = context.getString(R.string.permission_name_calendar);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.CAMERA": {
                    String message = context.getString(R.string.permission_name_camera);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.READ_CONTACTS": 
                case "android.permission.WRITE_CONTACTS": {
                    String message = context.getString(R.string.permission_name_contacts);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.GET_ACCOUNTS": {
                    String message = context.getString(R.string.permission_name_accounts);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.ACCESS_FINE_LOCATION": 
                case "android.permission.ACCESS_COARSE_LOCATION": {
                    String message = context.getString(R.string.permission_name_location);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.RECORD_AUDIO": {
                    String message = context.getString(R.string.permission_name_microphone);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.READ_PHONE_STATE": 
                case "android.permission.CALL_PHONE": 
                case "android.permission.READ_CALL_LOG": 
                case "android.permission.WRITE_CALL_LOG": 
                case "com.android.voicemail.permission.ADD_VOICEMAIL": 
                case "android.permission.ADD_VOICEMAIL": 
                case "android.permission.USE_SIP": 
                case "android.permission.PROCESS_OUTGOING_CALLS": 
                case "android.permission.READ_PHONE_NUMBERS": 
                case "android.permission.ANSWER_PHONE_CALLS": {
                    String message = context.getString(R.string.permission_name_phone);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.BODY_SENSORS": {
                    String message = context.getString(R.string.permission_name_sensors);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.SEND_SMS": 
                case "android.permission.RECEIVE_SMS": 
                case "android.permission.READ_SMS": 
                case "android.permission.RECEIVE_WAP_PUSH": 
                case "android.permission.RECEIVE_MMS": {
                    String message = context.getString(R.string.permission_name_sms);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
                case "android.permission.READ_EXTERNAL_STORAGE": 
                case "android.permission.WRITE_EXTERNAL_STORAGE": {
                    String message = context.getString(R.string.permission_name_storage);
                    if (textList.contains(message)) break;
                    textList.add(message);
                    break;
                }
            }
        }
        return textList;
    }

    public static final class Group {
        public static final String[] CALENDAR = new String[]{"android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR"};
        public static final String[] CAMERA = new String[]{"android.permission.CAMERA"};
        public static final String[] CONTACTS = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.GET_ACCOUNTS"};
        public static final String[] LOCATION = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
        public static final String[] MICROPHONE = new String[]{"android.permission.RECORD_AUDIO"};
        public static final String[] PHONE = Build.VERSION.SDK_INT >= 26 ? new String[]{"android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.READ_PHONE_NUMBERS", "android.permission.ANSWER_PHONE_CALLS"} : new String[]{"android.permission.READ_PHONE_STATE", "android.permission.CALL_PHONE", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS"};
        public static final String[] SENSORS = new String[]{"android.permission.BODY_SENSORS"};
        public static final String[] SMS = new String[]{"android.permission.SEND_SMS", "android.permission.RECEIVE_SMS", "android.permission.READ_SMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.RECEIVE_MMS"};
        public static final String[] STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }
}

