/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.bridge.BridgeRequest;
import com.yanzhenjie.permission.bridge.RequestManager;
import com.yanzhenjie.permission.checker.DoubleChecker;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StandardChecker;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MRequest
implements PermissionRequest,
RequestExecutor,
BridgeRequest.Callback {
    private static final PermissionChecker STANDARD_CHECKER = new StandardChecker();
    private static final PermissionChecker DOUBLE_CHECKER = new DoubleChecker();
    private Source mSource;
    private String[] mPermissions;
    private Rationale<List<String>> mRationale = new Rationale<List<String>>(){

        @Override
        public void showRationale(Context context, List<String> data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<List<String>> mGranted;
    private Action<List<String>> mDenied;
    private String[] mDeniedPermissions;

    MRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    public PermissionRequest rationale(Rationale<List<String>> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public PermissionRequest onGranted(Action<List<String>> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public PermissionRequest onDenied(Action<List<String>> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        List<String> deniedList = MRequest.getDeniedPermissions(STANDARD_CHECKER, this.mSource, this.mPermissions);
        this.mDeniedPermissions = deniedList.toArray(new String[deniedList.size()]);
        if (this.mDeniedPermissions.length > 0) {
            List<String> rationaleList = MRequest.getRationalePermissions(this.mSource, this.mDeniedPermissions);
            if (rationaleList.size() > 0) {
                this.mRationale.showRationale(this.mSource.getContext(), rationaleList, this);
            } else {
                this.execute();
            }
        } else {
            this.onCallback();
        }
    }

    @Override
    public void execute() {
        BridgeRequest request = new BridgeRequest(this.mSource);
        request.setType(2);
        request.setPermissions(this.mDeniedPermissions);
        request.setCallback(this);
        RequestManager.get().add(request);
    }

    @Override
    public void cancel() {
        this.onCallback();
    }

    @Override
    public void onCallback() {
        new AsyncTask<Void, Void, List<String>>(){

            protected List<String> doInBackground(Void ... voids) {
                return MRequest.getDeniedPermissions(DOUBLE_CHECKER, MRequest.this.mSource, MRequest.this.mPermissions);
            }

            protected void onPostExecute(List<String> deniedList) {
                if (deniedList.isEmpty()) {
                    MRequest.this.callbackSucceed();
                } else {
                    MRequest.this.callbackFailed(deniedList);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    Log.e((String)"AndPermission", (String)"Please check the onGranted() method body for bugs.", (Throwable)e);
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(PermissionChecker checker, Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (checker.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }

    private static List<String> getRationalePermissions(Source source, String ... permissions) {
        ArrayList<String> rationaleList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (!source.isShowRationalePermission(permission)) continue;
            rationaleList.add(permission);
        }
        return rationaleList;
    }
}

