/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.runtime;

import android.os.AsyncTask;
import android.util.Log;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.checker.StrictChecker;
import com.yanzhenjie.permission.runtime.PermissionRequest;
import com.yanzhenjie.permission.source.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class LRequest
implements PermissionRequest {
    private static final PermissionChecker STRICT_CHECKER = new StrictChecker();
    private Source mSource;
    private String[] mPermissions;
    private Action<List<String>> mGranted;
    private Action<List<String>> mDenied;

    LRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission(String ... permissions) {
        this.mPermissions = permissions;
        return this;
    }

    @Override
    public PermissionRequest rationale(Rationale<List<String>> rationale) {
        return this;
    }

    @Override
    public PermissionRequest onGranted(Action<List<String>> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public PermissionRequest onDenied(Action<List<String>> denied) {
        this.mDenied = denied;
        return this;
    }

    @Override
    public void start() {
        new AsyncTask<Void, Void, List<String>>(){

            protected List<String> doInBackground(Void ... voids) {
                return LRequest.getDeniedPermissions(STRICT_CHECKER, LRequest.this.mSource, LRequest.this.mPermissions);
            }

            protected void onPostExecute(List<String> deniedList) {
                if (deniedList.isEmpty()) {
                    LRequest.this.callbackSucceed();
                } else {
                    LRequest.this.callbackFailed(deniedList);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private void callbackSucceed() {
        block3: {
            if (this.mGranted != null) {
                List<String> permissionList = Arrays.asList(this.mPermissions);
                try {
                    this.mGranted.onAction(permissionList);
                }
                catch (Exception e) {
                    Log.e((String)"AndPermission", (String)"Please check the onGranted() method body for bugs.", (Throwable)e);
                    if (this.mDenied == null) break block3;
                    this.mDenied.onAction(permissionList);
                }
            }
        }
    }

    private void callbackFailed(List<String> deniedList) {
        if (this.mDenied != null) {
            this.mDenied.onAction(deniedList);
        }
    }

    private static List<String> getDeniedPermissions(PermissionChecker checker, Source source, String ... permissions) {
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission : permissions) {
            if (checker.hasPermission(source.getContext(), permission)) continue;
            deniedList.add(permission);
        }
        return deniedList;
    }
}

