/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.overlay.setting;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;

public class MSettingPage {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public MSettingPage(Source source) {
        this.mSource = source;
    }

    public void start(int requestCode) {
        Intent intent = MARK.contains("meizu") ? MSettingPage.meiZuApi(this.mSource.getContext()) : MSettingPage.defaultApi(this.mSource.getContext());
        try {
            this.mSource.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            intent = MSettingPage.appDetailsApi(this.mSource.getContext());
            this.mSource.startActivityForResult(intent, requestCode);
        }
    }

    private static Intent appDetailsApi(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private static Intent defaultApi(Context context) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        if (MSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return MSettingPage.appDetailsApi(context);
    }

    private static Intent meiZuApi(Context context) {
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setClassName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity");
        if (MSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return MSettingPage.defaultApi(context);
    }

    private static boolean hasActivity(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }
}

