/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.overlay.setting;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.source.Source;

public class LSettingPage {
    private static final String MARK = Build.MANUFACTURER.toLowerCase();
    private Source mSource;

    public LSettingPage(Source source) {
        this.mSource = source;
    }

    public void start(int requestCode) {
        Intent intent = MARK.contains("huawei") ? this.huaweiApi(this.mSource.getContext()) : (MARK.contains("xiaomi") ? this.xiaomiApi(this.mSource.getContext()) : (MARK.contains("oppo") ? this.oppoApi(this.mSource.getContext()) : (MARK.contains("vivo") ? this.vivoApi(this.mSource.getContext()) : (MARK.contains("meizu") ? this.meizuApi(this.mSource.getContext()) : LSettingPage.defaultApi(this.mSource.getContext())))));
        try {
            this.mSource.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            intent = LSettingPage.defaultApi(this.mSource.getContext());
            this.mSource.startActivityForResult(intent, requestCode);
        }
    }

    private static Intent defaultApi(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private Intent huaweiApi(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.addviewmonitor.AddViewMonitorActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.huawei.systemmanager", "com.huawei.notificationmanager.ui.NotificationManagmentActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return LSettingPage.defaultApi(context);
    }

    private Intent xiaomiApi(Context context) {
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.putExtra("extra_pkgname", context.getPackageName());
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return LSettingPage.defaultApi(context);
    }

    private Intent oppoApi(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packageName", context.getPackageName());
        intent.setClassName("com.color.safecenter", "com.color.safecenter.permission.floatwindow.FloatWindowListActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.coloros.safecenter", "com.coloros.safecenter.sysfloatwindow.FloatWindowListActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.oppo.safe", "com.oppo.safe.permission.PermissionAppListActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return LSettingPage.defaultApi(context);
    }

    private Intent vivoApi(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.iqoo.secure", "com.iqoo.secure.ui.phoneoptimize.FloatWindowManager");
        intent.putExtra("packagename", context.getPackageName());
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        intent.setClassName("com.iqoo.secure", "com.iqoo.secure.safeguard.SoftPermissionDetailActivity");
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return LSettingPage.defaultApi(context);
    }

    private Intent meizuApi(Context context) {
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity"));
        if (LSettingPage.hasActivity(context, intent)) {
            return intent;
        }
        return LSettingPage.defaultApi(context);
    }

    private static boolean hasActivity(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }
}

