/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.overlay;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.R;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.overlay.OverlayRequest;
import com.yanzhenjie.permission.source.Source;

abstract class BaseRequest
implements OverlayRequest {
    private Source mSource;
    private Rationale<Void> mRationale = new Rationale<Void>(){

        @Override
        public void showRationale(Context context, Void data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<Void> mGranted;
    private Action<Void> mDenied;

    BaseRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public final OverlayRequest rationale(Rationale<Void> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public final OverlayRequest onGranted(Action<Void> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public final OverlayRequest onDenied(Action<Void> denied) {
        this.mDenied = denied;
        return this;
    }

    final void showRationale(RequestExecutor executor) {
        this.mRationale.showRationale(this.mSource.getContext(), null, executor);
    }

    final void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(null);
        }
    }

    final void callbackFailed() {
        if (this.mDenied != null) {
            this.mDenied.onAction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tryDisplayDialog(Context context) {
        Dialog dialog = new Dialog(context, R.style.Permission_Theme);
        int overlay = 2038;
        int alertWindow = 2003;
        int windowType = Build.VERSION.SDK_INT >= 26 ? overlay : alertWindow;
        dialog.getWindow().setType(windowType);
        try {
            dialog.show();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dialog.isShowing()) {
                dialog.dismiss();
            }
        }
        return true;
    }
}

