/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.notify.listener;

import android.content.Context;
import com.yanzhenjie.permission.Action;
import com.yanzhenjie.permission.Rationale;
import com.yanzhenjie.permission.RequestExecutor;
import com.yanzhenjie.permission.notify.listener.ListenerRequest;
import com.yanzhenjie.permission.source.Source;

abstract class BaseRequest
implements ListenerRequest {
    private Source mSource;
    private Rationale<Void> mRationale = new Rationale<Void>(){

        @Override
        public void showRationale(Context context, Void data, RequestExecutor executor) {
            executor.execute();
        }
    };
    private Action<Void> mGranted;
    private Action<Void> mDenied;

    BaseRequest(Source source) {
        this.mSource = source;
    }

    @Override
    public final ListenerRequest rationale(Rationale<Void> rationale) {
        this.mRationale = rationale;
        return this;
    }

    @Override
    public final ListenerRequest onGranted(Action<Void> granted) {
        this.mGranted = granted;
        return this;
    }

    @Override
    public final ListenerRequest onDenied(Action<Void> denied) {
        this.mDenied = denied;
        return this;
    }

    final void showRationale(RequestExecutor executor) {
        this.mRationale.showRationale(this.mSource.getContext(), null, executor);
    }

    final void callbackSucceed() {
        if (this.mGranted != null) {
            this.mGranted.onAction(null);
        }
    }

    final void callbackFailed() {
        if (this.mDenied != null) {
            this.mDenied.onAction(null);
        }
    }
}

