/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.notify;

import android.os.Build;
import com.yanzhenjie.permission.notify.NRequestFactory;
import com.yanzhenjie.permission.notify.ORequestFactory;
import com.yanzhenjie.permission.notify.PermissionRequest;
import com.yanzhenjie.permission.notify.listener.J1RequestFactory;
import com.yanzhenjie.permission.notify.listener.J2RequestFactory;
import com.yanzhenjie.permission.notify.listener.ListenerRequest;
import com.yanzhenjie.permission.notify.option.NotifyOption;
import com.yanzhenjie.permission.source.Source;

public class Notify
implements NotifyOption {
    private static final PermissionRequestFactory PERMISSION_REQUEST_FACTORY = Build.VERSION.SDK_INT >= 26 ? new ORequestFactory() : new NRequestFactory();
    private static final ListenerRequestFactory LISTENER_REQUEST_FACTORY = Build.VERSION.SDK_INT >= 18 ? new J2RequestFactory() : new J1RequestFactory();
    private Source mSource;

    public Notify(Source source) {
        this.mSource = source;
    }

    @Override
    public PermissionRequest permission() {
        return PERMISSION_REQUEST_FACTORY.create(this.mSource);
    }

    @Override
    public ListenerRequest listener() {
        return LISTENER_REQUEST_FACTORY.create(this.mSource);
    }

    public static interface ListenerRequestFactory {
        public ListenerRequest create(Source var1);
    }

    public static interface PermissionRequestFactory {
        public PermissionRequest create(Source var1);
    }
}

