/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.checker;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.yanzhenjie.permission.checker.PermissionChecker;
import java.util.Arrays;
import java.util.List;

public final class StandardChecker
implements PermissionChecker {
    private static final int MODE_ASK = 4;

    @Override
    public boolean hasPermission(Context context, String ... permissions) {
        return this.hasPermission(context, Arrays.asList(permissions));
    }

    @Override
    public boolean hasPermission(Context context, List<String> permissions) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        AppOpsManager opsManager = null;
        for (String permission : permissions) {
            int result = context.checkPermission(permission, Process.myPid(), Process.myUid());
            if (result == -1) {
                return false;
            }
            String op = AppOpsManager.permissionToOp((String)permission);
            if (TextUtils.isEmpty((CharSequence)op)) continue;
            if (opsManager == null) {
                opsManager = (AppOpsManager)context.getSystemService("appops");
            }
            if ((result = opsManager.checkOpNoThrow(op, Process.myUid(), context.getPackageName())) == 0 || result == 4) continue;
            return false;
        }
        return true;
    }
}

