/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.checker;

import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioRecord;
import com.yanzhenjie.permission.checker.PermissionTest;

class RecordAudioTest
implements PermissionTest {
    private static final int[] RATES = new int[]{8000, 11025, 22050, 44100};
    private Context mContext;

    RecordAudioTest(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws Throwable {
        block7: {
            AudioRecord audioRecord = RecordAudioTest.findAudioRecord();
            try {
                if (audioRecord != null) {
                    audioRecord.startRecording();
                    break block7;
                }
                boolean bl = !RecordAudioTest.existMicrophone(this.mContext);
                return bl;
            }
            catch (Throwable e) {
                boolean bl = !RecordAudioTest.existMicrophone(this.mContext);
                return bl;
            }
            finally {
                if (audioRecord != null) {
                    audioRecord.stop();
                    audioRecord.release();
                }
            }
        }
        return true;
    }

    private static boolean existMicrophone(Context context) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.hasSystemFeature("android.hardware.microphone");
    }

    private static AudioRecord findAudioRecord() {
        for (int rate : RATES) {
            for (short format : new short[]{3, 2}) {
                for (short channel : new short[]{16, 12}) {
                    AudioRecord recorder;
                    int buffer = AudioRecord.getMinBufferSize((int)rate, (int)channel, (int)format);
                    if (buffer == -2 || (recorder = new AudioRecord(1, rate, (int)channel, (int)format, buffer)).getState() != 1) continue;
                    return recorder;
                }
            }
        }
        return null;
    }
}

