/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.bridge;

import com.yanzhenjie.permission.bridge.BridgeActivity;
import com.yanzhenjie.permission.bridge.BridgeRequest;
import com.yanzhenjie.permission.bridge.Messenger;
import java.util.concurrent.BlockingQueue;

final class RequestExecutor
extends Thread
implements Messenger.Callback {
    private final BlockingQueue<BridgeRequest> mQueue;
    private BridgeRequest mRequest;
    private Messenger mMessenger;

    public RequestExecutor(BlockingQueue<BridgeRequest> queue) {
        this.mQueue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            RequestExecutor requestExecutor = this;
            synchronized (requestExecutor) {
                try {
                    this.mRequest = this.mQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.mMessenger = new Messenger(this.mRequest.getSource().getContext(), this);
                this.mMessenger.register();
                this.executeCurrent();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void executeCurrent() {
        switch (this.mRequest.getType()) {
            case 1: {
                BridgeActivity.requestAppDetails(this.mRequest.getSource());
                break;
            }
            case 2: {
                BridgeActivity.requestPermission(this.mRequest.getSource(), this.mRequest.getPermissions());
                break;
            }
            case 3: {
                BridgeActivity.requestInstall(this.mRequest.getSource());
                break;
            }
            case 4: {
                BridgeActivity.requestOverlay(this.mRequest.getSource());
                break;
            }
            case 5: {
                BridgeActivity.requestAlertWindow(this.mRequest.getSource());
                break;
            }
            case 6: {
                BridgeActivity.requestNotify(this.mRequest.getSource());
                break;
            }
            case 7: {
                BridgeActivity.requestNotificationListener(this.mRequest.getSource());
                break;
            }
            case 8: {
                BridgeActivity.requestWriteSetting(this.mRequest.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCallback() {
        RequestExecutor requestExecutor = this;
        synchronized (requestExecutor) {
            this.mMessenger.unRegister();
            this.mRequest.getCallback().onCallback();
            this.notify();
        }
    }
}

