/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission.bridge;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.KeyEvent;
import com.yanzhenjie.permission.bridge.Messenger;
import com.yanzhenjie.permission.overlay.setting.LSettingPage;
import com.yanzhenjie.permission.overlay.setting.MSettingPage;
import com.yanzhenjie.permission.source.ActivitySource;
import com.yanzhenjie.permission.source.Source;

public final class BridgeActivity
extends Activity {
    private static final String KEY_TYPE = "KEY_TYPE";
    private static final String KEY_PERMISSIONS = "KEY_PERMISSIONS";

    static void requestAppDetails(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 1);
        source.startActivity(intent);
    }

    static void requestPermission(Source source, String[] permissions) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 2);
        intent.putExtra(KEY_PERMISSIONS, permissions);
        source.startActivity(intent);
    }

    static void requestInstall(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 3);
        source.startActivity(intent);
    }

    static void requestOverlay(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 4);
        source.startActivity(intent);
    }

    static void requestAlertWindow(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 5);
        source.startActivity(intent);
    }

    static void requestNotify(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 6);
        source.startActivity(intent);
    }

    static void requestNotificationListener(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 7);
        source.startActivity(intent);
    }

    static void requestWriteSetting(Source source) {
        Intent intent = new Intent(source.getContext(), BridgeActivity.class);
        intent.putExtra(KEY_TYPE, 8);
        source.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            return;
        }
        Intent intent = this.getIntent();
        int operation = intent.getIntExtra(KEY_TYPE, -1);
        switch (operation) {
            case 1: {
                Intent appDetailsIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                appDetailsIntent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
                this.startActivityForResult(appDetailsIntent, 1);
                break;
            }
            case 2: {
                String[] permissions = intent.getStringArrayExtra(KEY_PERMISSIONS);
                this.requestPermissions(permissions, 2);
                break;
            }
            case 3: {
                Intent manageIntent = new Intent("android.settings.MANAGE_UNKNOWN_APP_SOURCES");
                manageIntent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
                this.startActivityForResult(manageIntent, 3);
                break;
            }
            case 4: {
                MSettingPage settingPage = new MSettingPage(new ActivitySource(this));
                settingPage.start(4);
                break;
            }
            case 5: {
                LSettingPage settingPage = new LSettingPage(new ActivitySource(this));
                settingPage.start(5);
                break;
            }
            case 6: {
                Intent settingIntent = new Intent("android.settings.APP_NOTIFICATION_SETTINGS");
                settingIntent.putExtra("android.provider.extra.APP_PACKAGE", this.getPackageName());
                this.startActivityForResult(settingIntent, 6);
                break;
            }
            case 7: {
                Intent settingIntent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                this.startActivityForResult(settingIntent, 7);
                break;
            }
            case 8: {
                Intent settingIntent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
                settingIntent.setData(Uri.fromParts((String)"package", (String)this.getPackageName(), null));
                this.startActivityForResult(settingIntent, 8);
                break;
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Messenger.send((Context)this);
        this.finish();
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Messenger.send((Context)this);
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

