/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.os.Build;
import com.yanzhenjie.permission.install.InstallRequest;
import com.yanzhenjie.permission.install.NRequestFactory;
import com.yanzhenjie.permission.install.ORequestFactory;
import com.yanzhenjie.permission.notify.Notify;
import com.yanzhenjie.permission.notify.option.NotifyOption;
import com.yanzhenjie.permission.option.Option;
import com.yanzhenjie.permission.overlay.LRequestFactory;
import com.yanzhenjie.permission.overlay.MRequestFactory;
import com.yanzhenjie.permission.overlay.OverlayRequest;
import com.yanzhenjie.permission.runtime.Runtime;
import com.yanzhenjie.permission.runtime.option.RuntimeOption;
import com.yanzhenjie.permission.setting.Setting;
import com.yanzhenjie.permission.source.Source;

public class Boot
implements Option {
    private static final InstallRequestFactory INSTALL_REQUEST_FACTORY = Build.VERSION.SDK_INT >= 26 ? new ORequestFactory() : new NRequestFactory();
    private static final OverlayRequestFactory OVERLAY_REQUEST_FACTORY = Build.VERSION.SDK_INT >= 23 ? new MRequestFactory() : new LRequestFactory();
    private Source mSource;

    public Boot(Source source) {
        this.mSource = source;
    }

    @Override
    public RuntimeOption runtime() {
        return new Runtime(this.mSource);
    }

    @Override
    public InstallRequest install() {
        return INSTALL_REQUEST_FACTORY.create(this.mSource);
    }

    @Override
    public OverlayRequest overlay() {
        return OVERLAY_REQUEST_FACTORY.create(this.mSource);
    }

    @Override
    public NotifyOption notification() {
        return new Notify(this.mSource);
    }

    @Override
    public Setting setting() {
        return new Setting(this.mSource);
    }

    public static interface OverlayRequestFactory {
        public OverlayRequest create(Source var1);
    }

    public static interface InstallRequestFactory {
        public InstallRequest create(Source var1);
    }
}

