/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.permission;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.net.Uri;
import android.os.Build;
import com.yanzhenjie.permission.Boot;
import com.yanzhenjie.permission.FileProvider;
import com.yanzhenjie.permission.checker.DoubleChecker;
import com.yanzhenjie.permission.checker.PermissionChecker;
import com.yanzhenjie.permission.option.Option;
import com.yanzhenjie.permission.source.ActivitySource;
import com.yanzhenjie.permission.source.ContextSource;
import com.yanzhenjie.permission.source.FragmentSource;
import com.yanzhenjie.permission.source.Source;
import com.yanzhenjie.permission.source.SupportFragmentSource;
import java.io.File;
import java.util.List;

public class AndPermission {
    private static final PermissionChecker PERMISSION_CHECKER = new DoubleChecker();

    public static Option with(Context context) {
        return new Boot(AndPermission.getContextSource(context));
    }

    public static Option with(android.support.v4.app.Fragment fragment) {
        return new Boot(new SupportFragmentSource(fragment));
    }

    public static Option with(Fragment fragment) {
        return new Boot(new FragmentSource(fragment));
    }

    public static Option with(Activity activity) {
        return new Boot(new ActivitySource(activity));
    }

    public static boolean hasAlwaysDeniedPermission(Context context, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission(AndPermission.getContextSource(context), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(android.support.v4.app.Fragment fragment, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Fragment fragment, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Activity activity, List<String> deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ActivitySource(activity), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(Source source, List<String> deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlwaysDeniedPermission(Context context, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission(AndPermission.getContextSource(context), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(android.support.v4.app.Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new SupportFragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Fragment fragment, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new FragmentSource(fragment), deniedPermissions);
    }

    public static boolean hasAlwaysDeniedPermission(Activity activity, String ... deniedPermissions) {
        return AndPermission.hasAlwaysDeniedPermission((Source)new ActivitySource(activity), deniedPermissions);
    }

    private static boolean hasAlwaysDeniedPermission(Source source, String ... deniedPermissions) {
        for (String permission : deniedPermissions) {
            if (source.isShowRationalePermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        return PERMISSION_CHECKER.hasPermission(context, permissions);
    }

    public static boolean hasPermissions(android.support.v4.app.Fragment fragment, String ... permissions) {
        return AndPermission.hasPermissions((Activity)fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Fragment fragment, String ... permissions) {
        return AndPermission.hasPermissions(fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Activity activity, String ... permissions) {
        return PERMISSION_CHECKER.hasPermission((Context)activity, permissions);
    }

    public static boolean hasPermissions(Context context, String[] ... permissions) {
        for (String[] permission : permissions) {
            boolean hasPermission = PERMISSION_CHECKER.hasPermission(context, permission);
            if (hasPermission) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPermissions(android.support.v4.app.Fragment fragment, String[] ... permissions) {
        return AndPermission.hasPermissions((Activity)fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Fragment fragment, String[] ... permissions) {
        return AndPermission.hasPermissions(fragment.getActivity(), permissions);
    }

    public static boolean hasPermissions(Activity activity, String[] ... permissions) {
        for (String[] permission : permissions) {
            boolean hasPermission = PERMISSION_CHECKER.hasPermission((Context)activity, permission);
            if (hasPermission) continue;
            return false;
        }
        return true;
    }

    public static Uri getFileUri(Context context, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile(context, context.getPackageName() + ".file.path.share", file);
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getFileUri(android.support.v4.app.Fragment fragment, File file) {
        return AndPermission.getFileUri(fragment.getContext(), file);
    }

    public static Uri getFileUri(Fragment fragment, File file) {
        return AndPermission.getFileUri(fragment.getActivity(), file);
    }

    public static Uri getFileUri(Activity activity, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)activity, activity.getPackageName() + ".file.path.share", file);
        }
        return Uri.fromFile((File)file);
    }

    private static Source getContextSource(Context context) {
        if (context instanceof Activity) {
            return new ActivitySource((Activity)context);
        }
        if (context instanceof ContextWrapper) {
            return AndPermission.getContextSource(((ContextWrapper)context).getBaseContext());
        }
        return new ContextSource(context);
    }

    private AndPermission() {
    }
}

