/*
 * Decompiled with CFR 0.152.
 */
package org.apache.httpcore.message;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpVersion;
import org.apache.httpcore.ProtocolVersion;
import org.apache.httpcore.RequestLine;
import org.apache.httpcore.message.AbstractHttpMessage;
import org.apache.httpcore.message.BasicRequestLine;
import org.apache.httpcore.util.Args;

public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final Socket socket;
    private final String method;
    private final String uri;
    private RequestLine requestline;
    private String localName;
    private String localAddr;
    private int localPort = -1;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort = -1;

    public BasicHttpRequest(Socket socket, String method, String uri) {
        this.socket = socket;
        this.method = Args.notNull(method, "Method name");
        this.uri = Args.notNull(uri, "Request URI");
        this.requestline = null;
    }

    public BasicHttpRequest(Socket socket, String method, String uri, ProtocolVersion ver) {
        this(socket, new BasicRequestLine(method, uri, ver));
    }

    public BasicHttpRequest(Socket socket, RequestLine requestline) {
        this.socket = socket;
        this.requestline = Args.notNull(requestline, "Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.localName = ((InetSocketAddress)socketAddress).getHostName();
        }
        return this.localName;
    }

    @Override
    public String getLocalAddr() {
        if (this.localAddr != null) {
            return this.localAddr;
        }
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.localAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
        }
        return this.localAddr;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort != -1) {
            return this.localPort;
        }
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.localPort = ((InetSocketAddress)socketAddress).getPort();
        }
        return this.localPort;
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
        }
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.remoteHost = ((InetSocketAddress)socketAddress).getAddress().getHostName();
            if (this.remoteAddr == null) {
                this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
        }
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        if (this.remotePort != -1) {
            return this.remotePort;
        }
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.remotePort = ((InetSocketAddress)socketAddress).getPort();
        }
        return this.remotePort;
    }

    public String toString() {
        return this.method + ' ' + this.uri + ' ' + this.headergroup;
    }
}

