/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.processor;

import com.squareup.javapoet.TypeName;
import com.yanzhenjie.andserver.annotation.AppInfo;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String PLUGIN_MESSAGE = "\nAdd the plugin to your project build script :\nbuildscript {\n    repositories {\n       mavenCentral()\n       google()\n    }\n    dependencies {\n        classpath 'com.yanzhenjie.andserver:plugin:{version}'\n        ...\n    }\n}\n\nAnd then apply it in your module:\napply plugin: 'com.yanzhenjie.andserver'";

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        HashSet<Class<? extends Annotation>> classSet = new HashSet<Class<? extends Annotation>>();
        this.addAnnotation(classSet);
        HashSet<String> nameSet = new HashSet<String>();
        for (Class clazz : classSet) {
            nameSet.add(clazz.getCanonicalName());
        }
        return nameSet;
    }

    protected abstract void addAnnotation(Set<Class<? extends Annotation>> var1);

    protected boolean isAcceptType(TypeElement element, TypeName type) {
        Element parent;
        TypeMirror mirror = element.getSuperclass();
        if (mirror == null || mirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (type.equals((Object)TypeName.get((TypeMirror)mirror))) {
            return true;
        }
        if (mirror instanceof DeclaredType && (parent = ((DeclaredType)mirror).asElement()) instanceof TypeElement) {
            return this.isAcceptType((TypeElement)parent, type);
        }
        return false;
    }

    protected boolean isAcceptInterface(TypeElement element, TypeName type) {
        Element element2;
        List<? extends TypeMirror> mirrors = element.getInterfaces();
        for (TypeMirror typeMirror : mirrors) {
            if (!type.equals((Object)TypeName.get((TypeMirror)typeMirror))) continue;
            return true;
        }
        TypeMirror mirror = element.getSuperclass();
        if (mirror == null || mirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (mirror instanceof DeclaredType && (element2 = ((DeclaredType)mirror).asElement()) instanceof TypeElement) {
            return this.isAcceptInterface((TypeElement)element2, type);
        }
        return false;
    }

    protected String getRegisterPackageName(Set<? extends Element> appSet) {
        List list = appSet.stream().map(element -> {
            AppInfo appInfo = element.getAnnotation(AppInfo.class);
            return appInfo == null ? null : appInfo.value();
        }).collect(Collectors.toList());
        if (list.size() <= 0) {
            throw new RuntimeException(PLUGIN_MESSAGE);
        }
        String rootPackage = (String)list.get(0);
        return String.format("%s.%s", rootPackage, "andserver.processor.generator");
    }
}

