/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.plugin.util;

import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class Log {
    private static Logger sLogger;

    public static void inject(Project project) {
        sLogger = project.getLogger();
    }

    public void i(String format, Object ... args) {
        if (null != format && null != sLogger) {
            sLogger.info("AndServer::Info >>> " + String.format(format, args));
        }
    }

    public void d(String format, Object ... args) {
        if (null != format && null != sLogger) {
            sLogger.debug("AndServer::Debug >>> " + String.format(format, args));
        }
    }

    public void w(String format, Object ... args) {
        if (null != format && null != sLogger) {
            sLogger.warn("AndServer::Warn >>> " + String.format(format, args));
        }
    }

    public void e(String format, Object ... args) {
        if (null != format && null != sLogger) {
            sLogger.error("AndServer::Error >>> " + String.format(format, args));
        }
    }

    public void e(Throwable error) {
        if (null != error) {
            sLogger.error("AndServer::Error >>> " + Log.formatStackTrace(error.getStackTrace()));
        }
    }

    private static String formatStackTrace(StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append("    at ").append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

