/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.server;

import androidx.annotation.NonNull;
import com.yanzhenjie.andserver.AndServer;
import com.yanzhenjie.andserver.SSLSocketInitializer;
import com.yanzhenjie.andserver.Server;
import com.yanzhenjie.andserver.util.Executors;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import org.apache.httpcore.ExceptionLogger;
import org.apache.httpcore.config.SocketConfig;
import org.apache.httpcore.impl.bootstrap.HttpServer;
import org.apache.httpcore.impl.bootstrap.SSLServerSetupHandler;
import org.apache.httpcore.impl.bootstrap.ServerBootstrap;
import org.apache.httpcore.protocol.HttpRequestHandler;

public abstract class BasicServer<T extends Builder>
implements Server {
    protected final InetAddress mInetAddress;
    protected final int mPort;
    protected final int mTimeout;
    protected final ServerSocketFactory mSocketFactory;
    protected final SSLContext mSSLContext;
    protected final SSLSocketInitializer mSSLSocketInitializer;
    protected final Server.ServerListener mListener;
    private HttpServer mHttpServer;
    protected boolean isRunning;

    BasicServer(T builder) {
        this.mInetAddress = ((Builder)builder).inetAddress;
        this.mPort = ((Builder)builder).port;
        this.mTimeout = ((Builder)builder).timeout;
        this.mSocketFactory = ((Builder)builder).mSocketFactory;
        this.mSSLContext = ((Builder)builder).sslContext;
        this.mSSLSocketInitializer = ((Builder)builder).mSSLSocketInitializer;
        this.mListener = ((Builder)builder).listener;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void startup() {
        if (this.isRunning) {
            return;
        }
        Executors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BasicServer.this.mHttpServer = ServerBootstrap.bootstrap().setServerSocketFactory(BasicServer.this.mSocketFactory).setSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setTcpNoDelay(true).setSoTimeout(BasicServer.this.mTimeout).setSoLinger(0).build()).setLocalAddress(BasicServer.this.mInetAddress).setListenerPort(BasicServer.this.mPort).setSslContext(BasicServer.this.mSSLContext).setSslSetupHandler((SSLServerSetupHandler)new SSLSetup(BasicServer.this.mSSLSocketInitializer)).setServerInfo(AndServer.INFO).registerHandler("*", BasicServer.this.requestHandler()).setExceptionLogger(ExceptionLogger.NO_OP).create();
                    BasicServer.this.mHttpServer.start();
                    BasicServer.this.isRunning = true;
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (BasicServer.this.mListener != null) {
                                BasicServer.this.mListener.onStarted();
                            }
                        }
                    });
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            BasicServer.this.mHttpServer.shutdown(3L, TimeUnit.SECONDS);
                        }
                    });
                }
                catch (Exception e) {
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (BasicServer.this.mListener != null) {
                                BasicServer.this.mListener.onException(e);
                            }
                        }
                    });
                }
            }
        });
    }

    protected abstract HttpRequestHandler requestHandler();

    @Override
    public void shutdown() {
        if (!this.isRunning) {
            return;
        }
        Executors.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (BasicServer.this.mHttpServer != null) {
                    BasicServer.this.mHttpServer.shutdown(3L, TimeUnit.SECONDS);
                    BasicServer.this.isRunning = false;
                    Executors.getInstance().post(new Runnable(){

                        @Override
                        public void run() {
                            if (BasicServer.this.mListener != null) {
                                BasicServer.this.mListener.onStopped();
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.isRunning) {
            return this.mHttpServer.getInetAddress();
        }
        throw new IllegalStateException("The server has not been started yet.");
    }

    @Override
    public int getPort() {
        if (this.isRunning) {
            return this.mHttpServer.getLocalPort();
        }
        throw new IllegalStateException("The server has not been started yet.");
    }

    protected static abstract class Builder<T extends Builder, S extends BasicServer> {
        InetAddress inetAddress;
        int port;
        int timeout;
        ServerSocketFactory mSocketFactory;
        SSLContext sslContext;
        SSLSocketInitializer mSSLSocketInitializer;
        Server.ServerListener listener;

        Builder() {
        }

        public T inetAddress(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
            return (T)this;
        }

        public T port(int port) {
            this.port = port;
            return (T)this;
        }

        public T timeout(int timeout, TimeUnit timeUnit) {
            long timeoutMs = timeUnit.toMillis(timeout);
            this.timeout = (int)Math.min(timeoutMs, Integer.MAX_VALUE);
            return (T)this;
        }

        public T serverSocketFactory(ServerSocketFactory factory) {
            this.mSocketFactory = factory;
            return (T)this;
        }

        public T sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return (T)this;
        }

        public T sslSocketInitializer(SSLSocketInitializer initializer) {
            this.mSSLSocketInitializer = initializer;
            return (T)this;
        }

        public T listener(Server.ServerListener listener) {
            this.listener = listener;
            return (T)this;
        }

        public abstract S build();
    }

    private static final class SSLSetup
    implements SSLServerSetupHandler {
        private final SSLSocketInitializer mInitializer;

        public SSLSetup(@NonNull SSLSocketInitializer initializer) {
            this.mInitializer = initializer;
        }

        public void initialize(SSLServerSocket socket) throws SSLException {
            this.mInitializer.onCreated(socket);
        }
    }
}

