/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import android.text.TextUtils;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.util.LinkedMultiValueMap;
import com.yanzhenjie.andserver.util.MultiValueMap;
import com.yanzhenjie.andserver.util.Patterns;
import com.yanzhenjie.andserver.util.UrlCoder;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.Charsets;

public class Uri
implements Patterns {
    private final String mScheme;
    private final String mHost;
    private final int mPort;
    private final String mPath;
    private final String mQuery;
    private final String mFragment;

    public static Builder newBuilder(String uri) {
        return new Builder(uri);
    }

    private Uri(Builder builder) {
        this.mScheme = builder.mScheme;
        this.mHost = builder.mHost;
        this.mPort = builder.mPort;
        this.mPath = Uri.pathsToPath(builder.mPath);
        this.mQuery = Uri.parametersToQuery(builder.mQuery);
        this.mFragment = builder.mFragment;
    }

    @Nullable
    public String getScheme() {
        return this.mScheme;
    }

    @Nullable
    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @NonNull
    public List<String> getPaths() {
        return Uri.pathToPaths(this.mPath);
    }

    @NonNull
    public String getQuery() {
        return this.mQuery;
    }

    @NonNull
    public MultiValueMap<String, String> getParams() {
        return Uri.queryToParameters(this.mQuery);
    }

    @Nullable
    public String getFragment() {
        return this.mFragment;
    }

    @NonNull
    public Builder builder() {
        return new Builder(this.toString());
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.mScheme)) {
            builder.append(this.mScheme).append(":");
        }
        if (!TextUtils.isEmpty((CharSequence)this.mHost) && this.mPort > 0) {
            builder.append("//").append(this.mHost).append(":").append(this.mPort);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            builder.append(this.mPath);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mQuery)) {
            builder.append("?").append(this.mQuery);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mFragment)) {
            builder.append("#").append(this.mFragment);
        }
        return builder.toString();
    }

    @Nullable
    public Uri location(@Nullable String location) {
        if (TextUtils.isEmpty((CharSequence)location)) {
            return null;
        }
        if (URLUtil.isNetworkUrl((String)location)) {
            return Uri.newBuilder(location).build();
        }
        URI newUri = URI.create(location);
        if (location.startsWith("/")) {
            return this.builder().setPath(newUri.getPath()).setQuery(newUri.getQuery()).setFragment(newUri.getFragment()).build();
        }
        if (location.contains("../")) {
            List<String> oldPathList = Uri.pathToPaths(this.getPath());
            List<String> newPathList = Uri.pathToPaths(newUri.getPath());
            int start = newPathList.lastIndexOf("..");
            newPathList = newPathList.subList(start + 1, newPathList.size());
            if (!oldPathList.isEmpty()) {
                oldPathList = oldPathList.subList(0, oldPathList.size() - start - 2);
                oldPathList.addAll(newPathList);
                String path = TextUtils.join((CharSequence)"/", oldPathList);
                return this.builder().setPath(path).setQuery(newUri.getQuery()).setFragment(newUri.getFragment()).build();
            }
            String path = TextUtils.join((CharSequence)"/", newPathList);
            return this.builder().setPath(path).setQuery(newUri.getQuery()).setFragment(newUri.getFragment()).build();
        }
        List<String> oldPathList = Uri.pathToPaths(this.getPath());
        oldPathList.addAll(Uri.pathToPaths(newUri.getPath()));
        String path = TextUtils.join((CharSequence)"/", oldPathList);
        return this.builder().setPath(path).setQuery(newUri.getQuery()).setFragment(newUri.getFragment()).build();
    }

    public static List<String> pathToPaths(String path) {
        LinkedList<String> pathList = new LinkedList<String>();
        if (TextUtils.isEmpty((CharSequence)path)) {
            return pathList;
        }
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        while (path.contains("/")) {
            if (path.startsWith("/")) {
                pathList.add("");
                path = path.substring(1);
            } else {
                int index = path.indexOf("/");
                pathList.add(path.substring(0, index));
                path = path.substring(index + 1);
            }
            if (path.contains("/")) continue;
            pathList.add(path);
        }
        return pathList;
    }

    public static MultiValueMap<String, String> queryToParameters(String query) {
        LinkedMultiValueMap<String, String> valueMap = new LinkedMultiValueMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)query)) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            StringTokenizer tokenizer = new StringTokenizer(query, "&");
            while (tokenizer.hasMoreElements()) {
                String element = tokenizer.nextToken();
                int end = element.indexOf("=");
                if (end <= 0 || end >= element.length() - 1) continue;
                String key = element.substring(0, end);
                String value = element.substring(end + 1);
                valueMap.add(key, UrlCoder.urlDecode(value, Charsets.toCharset((String)"utf-8")));
            }
        }
        return valueMap;
    }

    public static String pathsToPath(List<String> pathList) {
        if (pathList == null || pathList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String path : pathList) {
            builder.append("/").append(path);
        }
        String path = builder.toString();
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    public static String parametersToQuery(MultiValueMap<String, String> params) {
        List valueList;
        String key;
        Map.Entry param;
        StringBuilder builder = new StringBuilder();
        Iterator iterator = params.entrySet().iterator();
        if (iterator.hasNext()) {
            param = iterator.next();
            key = (String)param.getKey();
            valueList = (List)param.getValue();
            if (valueList != null && !valueList.isEmpty()) {
                for (String value : valueList) {
                    builder.append(key).append("=").append(UrlCoder.urlEncode(value, "utf-8"));
                }
            } else {
                builder.append(key).append("=");
            }
        }
        while (iterator.hasNext()) {
            param = iterator.next();
            key = (String)param.getKey();
            valueList = (List)param.getValue();
            if (valueList != null && !valueList.isEmpty()) {
                for (String value : valueList) {
                    builder.append("&").append(key).append("=").append(UrlCoder.urlEncode(value, "utf-8"));
                }
                continue;
            }
            builder.append("&").append(key).append("=");
        }
        return builder.toString();
    }

    public static class Builder {
        private String mScheme;
        private String mHost;
        private int mPort;
        private List<String> mPath;
        private MultiValueMap<String, String> mQuery;
        private String mFragment;

        private Builder(@NonNull String url) {
            URI uri = URI.create(url);
            this.mScheme = uri.getScheme();
            this.mHost = uri.getHost();
            this.mPort = uri.getPort();
            String path = uri.getPath();
            this.mPath = Uri.pathToPaths(path);
            String query = uri.getRawQuery();
            this.mQuery = Uri.queryToParameters(query);
            this.mFragment = uri.getFragment();
        }

        public Builder setScheme(@Nullable String scheme) {
            this.mScheme = scheme;
            return this;
        }

        public Builder setHost(@Nullable String host) {
            this.mHost = host;
            return this;
        }

        public Builder setPort(int port) {
            this.mPort = port;
            return this;
        }

        public Builder addPath(int value) {
            return this.addPath(Integer.toString(value));
        }

        public Builder addPath(long value) {
            return this.addPath(Long.toString(value));
        }

        public Builder addPath(boolean value) {
            return this.addPath(Boolean.toString(value));
        }

        public Builder addPath(char value) {
            return this.addPath(String.valueOf(value));
        }

        public Builder addPath(double value) {
            return this.addPath(Double.toString(value));
        }

        public Builder addPath(float value) {
            return this.addPath(Float.toString(value));
        }

        public Builder addPath(@NonNull CharSequence path) {
            this.mPath.add(path.toString());
            return this;
        }

        public Builder addPath(@NonNull String path) {
            this.mPath.add(path);
            return this;
        }

        public Builder setPath(@NonNull String path) {
            this.mPath = Uri.pathToPaths(path);
            return this;
        }

        public Builder clearPath() {
            this.mPath.clear();
            return this;
        }

        public Builder addQuery(@NonNull String key, int value) {
            return this.addQuery(key, Integer.toString(value));
        }

        public Builder addQuery(@NonNull String key, long value) {
            return this.addQuery(key, Long.toString(value));
        }

        public Builder addQuery(@NonNull String key, boolean value) {
            return this.addQuery(key, Boolean.toString(value));
        }

        public Builder addQuery(@NonNull String key, char value) {
            return this.addQuery(key, String.valueOf(value));
        }

        public Builder addQuery(@NonNull String key, double value) {
            return this.addQuery(key, Double.toString(value));
        }

        public Builder addQuery(@NonNull String key, float value) {
            return this.addQuery(key, Float.toString(value));
        }

        public Builder addQuery(@NonNull String key, short value) {
            return this.addQuery(key, Integer.toString(value));
        }

        public Builder addQuery(@NonNull String key, @NonNull CharSequence value) {
            this.mQuery.add(key, value.toString());
            return this;
        }

        public Builder addQuery(@NonNull String key, @NonNull String value) {
            this.mQuery.add(key, value);
            return this;
        }

        public Builder addQuery(@NonNull String key, @NonNull List<String> values) {
            for (String value : values) {
                this.mQuery.add(key, value);
            }
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.mQuery = Uri.queryToParameters(query);
            return this;
        }

        public Builder setQuery(@NonNull MultiValueMap<String, String> query) {
            this.mQuery = query;
            return this;
        }

        public Builder removeQuery(@NonNull String key) {
            this.mQuery.remove(key);
            return this;
        }

        public Builder clearQuery() {
            this.mQuery.clear();
            return this;
        }

        public Builder setFragment(@Nullable String fragment) {
            this.mFragment = fragment;
            return this;
        }

        public Uri build() {
            return new Uri(this);
        }
    }
}

