/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.http;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.http.HttpHeaders;
import com.yanzhenjie.andserver.http.HttpMethod;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.util.HttpDateFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Modified
implements HttpHeaders {
    private static final Pattern ETAG_PATTERN = Pattern.compile("\\*|\\s*((W\\/)?(\"[^\"]*\"))\\s*,?");
    private HttpRequest mRequest;
    private HttpResponse mResponse;
    private boolean isNotModified;

    public Modified(@NonNull HttpRequest request, @NonNull HttpResponse response) {
        this.mRequest = request;
        this.mResponse = response;
    }

    public boolean process(long lastModified) {
        return this.process(null, lastModified);
    }

    public boolean process(String eTag) {
        return this.process(eTag, -1L);
    }

    public boolean process(@Nullable String eTag, long lastModified) {
        HttpMethod method;
        boolean isGetHead;
        if (this.isNotModified) {
            return true;
        }
        if (this.validateIfUnmodifiedSince(lastModified)) {
            if (!this.isNotModified) {
                this.mResponse.setStatus(411);
            }
            return this.isNotModified;
        }
        boolean validated = this.validateIfNoneMatch(eTag);
        if (!validated) {
            this.validateIfModifiedSince(lastModified);
        }
        boolean bl = isGetHead = (method = this.mRequest.getMethod()) == HttpMethod.GET || method == HttpMethod.HEAD;
        if (this.isNotModified) {
            this.mResponse.setStatus(isGetHead ? 304 : 411);
        }
        if (isGetHead) {
            if (lastModified > 0L && this.mResponse.getHeader("Last-Modified") == null) {
                this.mResponse.setDateHeader("Last-Modified", lastModified);
            }
            if (!TextUtils.isEmpty((CharSequence)eTag) && this.mResponse.getHeader("ETag") == null) {
                this.mResponse.setHeader("ETag", this.padETagIfNecessary(eTag));
            }
            this.mResponse.setHeader("Cache-Control", "private");
        }
        return this.isNotModified;
    }

    private boolean validateIfNoneMatch(String eTag) {
        if (TextUtils.isEmpty((CharSequence)eTag)) {
            return false;
        }
        List<String> ifNoneMatch = this.mRequest.getHeaders("If-None-Match");
        if (ifNoneMatch.isEmpty()) {
            return false;
        }
        eTag = this.padETagIfNecessary(eTag);
        block0: for (String clientETags : ifNoneMatch) {
            Matcher eTagMatcher = ETAG_PATTERN.matcher(clientETags);
            while (eTagMatcher.find()) {
                if (TextUtils.isEmpty((CharSequence)eTagMatcher.group()) || !eTag.replaceFirst("^W/", "").equals(eTagMatcher.group(3))) continue;
                this.isNotModified = true;
                continue block0;
            }
        }
        return true;
    }

    private String padETagIfNecessary(String eTag) {
        if (TextUtils.isEmpty((CharSequence)eTag)) {
            return eTag;
        }
        if ((eTag.startsWith("\"") || eTag.startsWith("W/\"")) && eTag.endsWith("\"")) {
            return eTag;
        }
        return "\"" + eTag + "\"";
    }

    private boolean validateIfModifiedSince(long lastModifiedTimestamp) {
        if (lastModifiedTimestamp < 0L) {
            return false;
        }
        long ifModifiedSince = this.parseDateHeader("If-Modified-Since");
        if (ifModifiedSince == -1L) {
            return false;
        }
        this.isNotModified = ifModifiedSince >= lastModifiedTimestamp;
        return true;
    }

    private boolean validateIfUnmodifiedSince(long lastModifiedTimestamp) {
        if (lastModifiedTimestamp < 0L) {
            return false;
        }
        long ifUnmodifiedSince = this.parseDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince == -1L) {
            return false;
        }
        this.isNotModified = ifUnmodifiedSince >= lastModifiedTimestamp;
        return true;
    }

    private long parseDateHeader(String headerName) {
        long dateValue;
        block3: {
            dateValue = -1L;
            try {
                dateValue = this.mRequest.getDateHeader(headerName);
            }
            catch (IllegalStateException ex) {
                String headerValue = this.mRequest.getHeader(headerName);
                if (TextUtils.isEmpty((CharSequence)headerValue)) {
                    return -1L;
                }
                int separatorIndex = headerValue.indexOf(59);
                if (separatorIndex == -1) break block3;
                String datePart = headerValue.substring(0, separatorIndex);
                dateValue = this.parseDateValue(datePart);
            }
        }
        return dateValue;
    }

    private long parseDateValue(String headerValue) {
        if (headerValue == null) {
            return -1L;
        }
        if (headerValue.length() >= 3) {
            return HttpDateFormat.parseDate(headerValue);
        }
        return -1L;
    }
}

