/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.website;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.framework.body.StreamBody;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.website.BasicWebsite;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.util.Assert;
import com.yanzhenjie.andserver.util.DigestUtils;
import com.yanzhenjie.andserver.util.IOUtils;
import com.yanzhenjie.andserver.util.MediaType;
import com.yanzhenjie.andserver.util.Patterns;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AssetsWebsite
extends BasicWebsite
implements Patterns {
    private final AssetsReader mAssetsReader;
    private final String mRootPath;
    private final PackageInfo mPackageInfo;

    public AssetsWebsite(@NonNull Context context, @NonNull String rootPath) {
        this(context, rootPath, "index.html");
    }

    public AssetsWebsite(@NonNull Context context, @NonNull String rootPath, @NonNull String indexFileName) {
        super(indexFileName);
        Assert.isTrue(!TextUtils.isEmpty((CharSequence)rootPath), "The rootPath cannot be empty.");
        Assert.isTrue(!TextUtils.isEmpty((CharSequence)indexFileName), "The indexFileName cannot be empty.");
        if (!rootPath.matches(PATH)) {
            String message = "The format of [%s] is wrong, it should be like [/root/project] or [/root/project/].";
            String format = String.format(message, rootPath);
            throw new IllegalArgumentException(format);
        }
        this.mAssetsReader = new AssetsReader(context.getAssets());
        this.mRootPath = this.trimSlash(rootPath);
        PackageManager packageManager = context.getPackageManager();
        try {
            this.mPackageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean intercept(@NonNull HttpRequest request) {
        String httpPath = request.getPath();
        InputStream stream = this.findPathSteam(httpPath);
        IOUtils.closeQuietly(stream);
        return stream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getETag(@NonNull HttpRequest request) throws Throwable {
        String httpPath = request.getPath();
        InputStream stream = this.findPathSteam(httpPath);
        if (stream != null) {
            try {
                String string = DigestUtils.md5DigestAsHex(stream);
                return string;
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        return null;
    }

    @Override
    public long getLastModified(@NonNull HttpRequest request) throws Throwable {
        String httpPath = request.getPath();
        InputStream stream = this.findPathSteam(httpPath);
        IOUtils.closeQuietly(stream);
        return stream != null ? this.mPackageInfo.lastUpdateTime : -1L;
    }

    @Override
    @NonNull
    public ResponseBody getBody(@NonNull HttpRequest request, @NonNull HttpResponse response) throws IOException {
        String httpPath = request.getPath();
        String objectPath = this.mRootPath + httpPath;
        InputStream stream = this.mAssetsReader.getInputStream(objectPath);
        if (stream != null) {
            MediaType mediaType = MediaType.getFileMediaType(objectPath);
            return new StreamBody(stream, stream.available(), mediaType);
        }
        String indexPath = this.addEndSlash(objectPath) + this.getIndexFileName();
        InputStream indexStream = this.mAssetsReader.getInputStream(indexPath);
        if (indexStream != null) {
            if (!httpPath.endsWith(File.separator)) {
                IOUtils.closeQuietly(indexStream);
                String redirectPath = this.addEndSlash(httpPath);
                String query = this.queryString(request);
                response.sendRedirect(redirectPath + "?" + query);
                return new StringBody("");
            }
            MediaType mediaType = MediaType.getFileMediaType(indexPath);
            return new StreamBody(indexStream, indexStream.available(), mediaType);
        }
        throw new NotFoundException(httpPath);
    }

    private InputStream findPathSteam(String httpPath) {
        String targetPath = this.mRootPath + httpPath;
        InputStream targetStream = this.mAssetsReader.getInputStream(targetPath);
        if (targetStream != null) {
            return targetStream;
        }
        String indexPath = this.addEndSlash(targetPath) + this.getIndexFileName();
        InputStream indexStream = this.mAssetsReader.getInputStream(indexPath);
        if (indexStream != null) {
            return indexStream;
        }
        return null;
    }

    public static class AssetsReader {
        private AssetManager mAssetManager;

        public AssetsReader(@NonNull AssetManager manager) {
            this.mAssetManager = manager;
        }

        @Nullable
        public InputStream getInputStream(@NonNull String filePath) {
            try {
                return this.mAssetManager.open(filePath);
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFile(@NonNull String fileName) {
            InputStream stream = null;
            try {
                stream = this.getInputStream(fileName);
                boolean bl = stream != null;
                return bl;
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }

        @NonNull
        public List<String> list(@NonNull String path) {
            ArrayList<String> fileList = new ArrayList<String>();
            try {
                String[] files = this.mAssetManager.list(path);
                Collections.addAll(fileList, files);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return fileList;
        }

        @NonNull
        public List<String> scanFile(@NonNull String path) {
            Assert.isTrue(!TextUtils.isEmpty((CharSequence)path), "The path cannot be empty.");
            ArrayList<String> pathList = new ArrayList<String>();
            if (this.isFile(path)) {
                pathList.add(path);
            } else {
                List<String> files = this.list(path);
                for (String file : files) {
                    String realPath = path + File.separator + file;
                    if (this.isFile(realPath)) {
                        pathList.add(realPath);
                        continue;
                    }
                    List<String> childList = this.scanFile(realPath);
                    if (childList.size() <= 0) continue;
                    pathList.addAll(childList);
                }
            }
            return pathList;
        }
    }
}

