/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver.framework.view;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.error.ServerInternalException;
import com.yanzhenjie.andserver.framework.MessageConverter;
import com.yanzhenjie.andserver.framework.body.StringBody;
import com.yanzhenjie.andserver.framework.view.View;
import com.yanzhenjie.andserver.http.HttpHeaders;
import com.yanzhenjie.andserver.http.HttpRequest;
import com.yanzhenjie.andserver.http.HttpResponse;
import com.yanzhenjie.andserver.http.RequestDispatcher;
import com.yanzhenjie.andserver.http.ResponseBody;
import com.yanzhenjie.andserver.http.StatusCode;
import com.yanzhenjie.andserver.util.MediaType;
import com.yanzhenjie.andserver.util.Patterns;

public class ViewResolver
implements Patterns,
StatusCode,
HttpHeaders {
    private MessageConverter mConverter;

    public ViewResolver() {
    }

    public ViewResolver(@Nullable MessageConverter converter) {
        this.mConverter = converter;
    }

    public void resolve(@Nullable View view, @NonNull HttpRequest request, @NonNull HttpResponse response) {
        if (view == null) {
            return;
        }
        Object output = view.output();
        if (view.rest()) {
            this.resolveRest(output, request, response);
        } else {
            this.resolvePath(output, request, response);
        }
    }

    private void resolveRest(Object output, @NonNull HttpRequest request, @NonNull HttpResponse response) {
        if (output instanceof ResponseBody) {
            response.setBody((ResponseBody)output);
        } else if (this.mConverter != null) {
            response.setBody(this.mConverter.convert(output, this.obtainProduce(request)));
        } else if (output == null) {
            response.setBody(new StringBody(""));
        } else if (output instanceof String) {
            response.setBody(new StringBody(output.toString(), this.obtainProduce(request)));
        } else {
            response.setBody(new StringBody(output.toString()));
        }
    }

    @Nullable
    private MediaType obtainProduce(@NonNull HttpRequest request) {
        Object mtAttribute = request.getAttribute("http.response.Produce");
        if (mtAttribute instanceof MediaType) {
            return (MediaType)mtAttribute;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolvePath(Object output, @NonNull HttpRequest request, @NonNull HttpResponse response) {
        if (!(output instanceof CharSequence)) throw new ServerInternalException(String.format("The return value of [%s] is not supported", output));
        String action = output.toString();
        if (TextUtils.isEmpty((CharSequence)action)) {
            return;
        }
        if (action.matches("redirect:(.)*")) {
            response.setStatus(302);
            if (action.length() < 9) return;
            String path = action.substring(9);
            response.setHeader("Location", path);
            return;
        } else if (action.matches("forward:(.)*")) {
            String path = action.substring(8);
            RequestDispatcher dispatcher = request.getRequestDispatcher(path);
            if (dispatcher == null) throw new NotFoundException(path);
            dispatcher.forward(request, response);
            return;
        } else {
            if (!action.matches(PATH)) throw new NotFoundException(action);
            String path = action + ".html";
            RequestDispatcher dispatcher = request.getRequestDispatcher(path);
            if (dispatcher == null) throw new NotFoundException(path);
            dispatcher.forward(request, response);
        }
    }
}

