/*
 * Decompiled with CFR 0.152.
 */
package com.yanzhenjie.andserver;

import com.yanzhenjie.andserver.AndServer;
import com.yanzhenjie.andserver.error.NotFoundException;
import com.yanzhenjie.andserver.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.httpcore.HttpClientConnection;
import org.apache.httpcore.HttpEntity;
import org.apache.httpcore.HttpException;
import org.apache.httpcore.HttpHost;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpRequestInterceptor;
import org.apache.httpcore.HttpResponse;
import org.apache.httpcore.entity.StringEntity;
import org.apache.httpcore.impl.DefaultBHttpClientConnection;
import org.apache.httpcore.impl.DefaultConnectionReuseStrategy;
import org.apache.httpcore.protocol.HttpContext;
import org.apache.httpcore.protocol.HttpProcessor;
import org.apache.httpcore.protocol.HttpRequestExecutor;
import org.apache.httpcore.protocol.HttpRequestHandler;
import org.apache.httpcore.protocol.ImmutableHttpProcessor;
import org.apache.httpcore.protocol.RequestConnControl;
import org.apache.httpcore.protocol.RequestContent;
import org.apache.httpcore.protocol.RequestExpectContinue;
import org.apache.httpcore.protocol.RequestTargetHost;
import org.apache.httpcore.protocol.RequestUserAgent;

public class ProxyHandler
implements HttpRequestHandler {
    private static final int BUFFER = 8192;
    private static final Set<String> HOP_BY_HOP = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Host", "Content-Length", "Transfer-Encoding", "Connection", "Proxy-Authenticate", "TE", "Trailer", "Upgrade")));
    private final Map<String, HttpHost> mHostList;
    private final SSLSocketFactory mSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private final HttpRequestExecutor mHttpExecutor = new HttpRequestExecutor();
    private final HttpProcessor mRequestProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(AndServer.INFO), new RequestExpectContinue(true)});

    public ProxyHandler(Map<String, HttpHost> hostList) {
        this.mHostList = hostList;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String hostHeader = request.getFirstHeader("Host").getValue();
        String hostName = HttpHost.create((String)hostHeader).getHostName();
        HttpHost host = this.mHostList.get(hostName.toLowerCase(Locale.ROOT));
        if (host == null) {
            NotFoundException e = new NotFoundException(request.getRequestLine().getUri());
            response.setStatusCode(e.getStatusCode());
            response.setEntity((HttpEntity)new StringEntity(e.getMessage()));
            return;
        }
        for (String name : HOP_BY_HOP) {
            request.removeHeaders(name);
        }
        DefaultBHttpClientConnection conn = (DefaultBHttpClientConnection)context.getAttribute("http.proxy.conn.client");
        if (!conn.isOpen() || conn.isStale()) {
            Socket socket = this.createSocket(host);
            conn.bind(socket);
        }
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)host);
        this.mHttpExecutor.preProcess(request, this.mRequestProcessor, context);
        HttpResponse outResponse = this.mHttpExecutor.execute(request, (HttpClientConnection)conn, context);
        this.mHttpExecutor.postProcess(response, this.mRequestProcessor, context);
        for (String name : HOP_BY_HOP) {
            outResponse.removeHeaders(name);
        }
        response.setStatusLine(outResponse.getStatusLine());
        response.setHeaders(outResponse.getAllHeaders());
        response.setEntity(outResponse.getEntity());
        boolean keepAlive = DefaultConnectionReuseStrategy.INSTANCE.keepAlive(response, context);
        context.setAttribute("http.proxy.conn.alive", (Object)keepAlive);
    }

    private Socket createSocket(HttpHost host) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(60000);
        socket.setReuseAddress(true);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(8192);
        socket.setSendBufferSize(8192);
        socket.setSoLinger(true, 0);
        String scheme = host.getSchemeName();
        String hostName = host.getHostName();
        int port = host.getPort();
        InetSocketAddress address = this.resolveAddress(scheme, hostName, port);
        socket.connect(address, 10000);
        if ("https".equalsIgnoreCase(scheme)) {
            SSLSocket sslSocket = (SSLSocket)this.mSocketFactory.createSocket(socket, hostName, port, true);
            try {
                sslSocket.startHandshake();
                SSLSession session = sslSocket.getSession();
                if (session == null) {
                    throw new SSLHandshakeException("SSL session not available.");
                }
            }
            catch (IOException ex) {
                IOUtils.closeQuietly(sslSocket);
                throw ex;
            }
            return sslSocket;
        }
        return socket;
    }

    private InetSocketAddress resolveAddress(String scheme, String hostName, int port) {
        if (port < 0) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        return new InetSocketAddress(hostName, port);
    }
}

