/*
 * Decompiled with CFR 0.152.
 */
package com.yangp.ypwaveview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.yangp.ypwaveview.R;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class YPWaveView
extends View {
    private float shiftX1 = 0.0f;
    private float waveVector = -0.25f;
    private int waveOffset = 25;
    private int speed = 25;
    private HandlerThread thread = new HandlerThread("YPWaveView_" + ((Object)((Object)this)).hashCode());
    private Handler animHandler;
    private Handler uiHandler;
    private Paint mBorderPaint = new Paint();
    private Paint mViewPaint = new Paint();
    private Path pathHeart;
    private Path pathStar;
    private static final int DEFAULT_PROGRESS = 405;
    private static final int DEFAULT_MAX = 1000;
    private static final int DEFAULT_STRONG = 50;
    public static final int DEFAULT_BEHIND_WAVE_COLOR = Color.parseColor((String)"#443030d5");
    public static final int DEFAULT_FRONT_WAVE_COLOR = Color.parseColor((String)"#FF3030d5");
    public static final int DEFAULT_BORDER_COLOR = Color.parseColor((String)"#000000");
    private static final float DEFAULT_BORDER_WIDTH = 5.0f;
    public static final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#000000");
    private static final boolean DEFAULT_ENABLE_ANIMATION = false;
    private static final boolean DEFAULT_HIDE_TEXT = false;
    private static final int DEFAULT_SPIKE_COUNT = 5;
    private int mProgress = 405;
    private int mMax = 1000;
    private int mFrontWaveColor = DEFAULT_FRONT_WAVE_COLOR;
    private int mBehindWaveColor = DEFAULT_BEHIND_WAVE_COLOR;
    private int mBorderColor = DEFAULT_BORDER_COLOR;
    private float mBorderWidth = 5.0f;
    private int mTextColor = DEFAULT_TEXT_COLOR;
    private boolean isAnimation = false;
    private boolean isHideText = false;
    private int mStrong = 50;
    private int mSpikes = 5;
    private Shape mShape = Shape.CIRCLE;
    private int value = 0;

    public YPWaveView(Context context) {
        this(context, null);
    }

    public YPWaveView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YPWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.YPWaveView, defStyleAttr, 0);
        this.mFrontWaveColor = attributes.getColor(R.styleable.YPWaveView_frontColor, DEFAULT_FRONT_WAVE_COLOR);
        this.mBehindWaveColor = attributes.getColor(R.styleable.YPWaveView_behideColor, DEFAULT_BEHIND_WAVE_COLOR);
        this.mBorderColor = attributes.getColor(R.styleable.YPWaveView_borderColor, DEFAULT_BORDER_COLOR);
        this.mTextColor = attributes.getColor(R.styleable.YPWaveView_textColor, DEFAULT_TEXT_COLOR);
        this.mProgress = attributes.getInt(R.styleable.YPWaveView_progress, 405);
        this.mMax = attributes.getInt(R.styleable.YPWaveView_max, 1000);
        this.mBorderWidth = attributes.getDimension(R.styleable.YPWaveView_borderWidthSize, 5.0f);
        this.mStrong = attributes.getInt(R.styleable.YPWaveView_strong, 50);
        this.mShape = Shape.fromValue(attributes.getInt(R.styleable.YPWaveView_shapeType, 1));
        this.isAnimation = attributes.getBoolean(R.styleable.YPWaveView_animatorEnable, false);
        this.isHideText = attributes.getBoolean(R.styleable.YPWaveView_textHidden, false);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.thread.start();
        this.animHandler = new Handler(this.thread.getLooper());
        this.uiHandler = new UIHandler(new WeakReference<View>(this));
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setProgress(int progress) {
        if (progress <= this.mMax) {
            this.mProgress = progress;
            this.createShader();
            Message message = Message.obtain((Handler)this.uiHandler);
            message.sendToTarget();
        }
    }

    public void startAnimation() {
        this.isAnimation = true;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.animHandler.post(new Runnable(){

                @Override
                public void run() {
                    YPWaveView.this.shiftX1 = YPWaveView.this.shiftX1 + YPWaveView.this.waveVector;
                    YPWaveView.this.createShader();
                    Message message = Message.obtain((Handler)YPWaveView.this.uiHandler);
                    message.sendToTarget();
                    if (YPWaveView.this.isAnimation) {
                        YPWaveView.this.animHandler.postDelayed((Runnable)this, (long)YPWaveView.this.speed);
                    }
                }
            });
        }
    }

    public void stopAnimation() {
        this.isAnimation = false;
    }

    public void setMax(int max) {
        if (this.mMax != max && max >= this.mProgress) {
            this.mMax = max;
            this.createShader();
            Message message = Message.obtain((Handler)this.uiHandler);
            message.sendToTarget();
        }
    }

    public void setBorderColor(int color) {
        this.mBorderColor = color;
        this.mBorderPaint.setColor(this.mBorderColor);
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setFrontWaveColor(int color) {
        this.mFrontWaveColor = color;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setBehindWaveColor(int color) {
        this.mBehindWaveColor = color;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setBorderWidth(float width) {
        this.mBorderWidth = width;
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setAnimationSpeed(int speed) {
        if (speed < 0) {
            throw new IllegalArgumentException("The speed must be greater than 0.");
        }
        this.speed = speed;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setWaveVector(float offset) {
        if (offset < 0.0f || offset > 100.0f) {
            throw new IllegalArgumentException("The vector of wave must be between 0 and 100.");
        }
        this.waveVector = (offset - 50.0f) / 50.0f;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setHideText(boolean hidden) {
        this.isHideText = hidden;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setStarSpikes(int count) {
        if (count < 3) {
            throw new IllegalArgumentException("The number of spikes must be greater than 3.");
        }
        this.mSpikes = count;
        if (this.value != 0) {
            int wOffset = (this.getWidth() - this.value) / 2;
            int hOffset = (this.getHeight() - this.value) / 2;
            this.pathStar = this.drawStart(this.value / 2 + wOffset, this.value / 2 + hOffset + (int)this.mBorderWidth, this.mSpikes, this.value / 2 - (int)this.mBorderWidth, this.value / 4);
            this.createShader();
            Message message = Message.obtain((Handler)this.uiHandler);
            message.sendToTarget();
        }
    }

    public void setWaveOffset(int offset) {
        this.waveOffset = offset;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setWaveStrong(int strong) {
        this.mStrong = strong;
        this.createShader();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setShape(Shape shape) {
        this.mShape = shape;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.value = Math.min(w, h);
        int wOffset = (w - this.value) / 2;
        int hOffset = (h - this.value) / 2;
        this.pathHeart = new Path();
        this.pathHeart.moveTo((float)(this.value / 2 + wOffset), (float)(this.value / 5 + hOffset));
        this.pathHeart.cubicTo((float)(5 * this.value / 14 + wOffset), (float)hOffset, (float)wOffset, (float)(this.value / 15 + hOffset), (float)(this.value / 28 + wOffset), (float)(2 * this.value / 5 + hOffset));
        this.pathHeart.cubicTo((float)(this.value / 14 + wOffset), (float)(2 * this.value / 3 + hOffset), (float)(3 * this.value / 7 + wOffset), (float)(5 * this.value / 6 + hOffset), (float)(this.value / 2 + wOffset), (float)(9 * this.value / 10 + hOffset));
        this.pathHeart.cubicTo((float)(4 * this.value / 7 + wOffset), (float)(5 * this.value / 6 + hOffset), (float)(13 * this.value / 14 + wOffset), (float)(2 * this.value / 3 + hOffset), (float)(27 * this.value / 28 + wOffset), (float)(2 * this.value / 5 + hOffset));
        this.pathHeart.cubicTo((float)(this.value + wOffset), (float)(this.value / 15 + hOffset), (float)(9 * this.value / 14 + wOffset), (float)hOffset, (float)(this.value / 2 + wOffset), (float)(this.value / 5 + hOffset));
        this.pathStar = this.drawStart(this.value / 2 + wOffset, this.value / 2 + hOffset + (int)this.mBorderWidth, this.mSpikes, this.value / 2 - (int)this.mBorderWidth, this.value / 4);
        this.createShader();
        if (this.isAnimation) {
            this.startAnimation();
        }
    }

    private Path drawStart(int cx, int cy, int spikes, int outerRadius, int innerRadius) {
        Path path = new Path();
        double rot = 4.71238898038469;
        double step = Math.PI / (double)spikes;
        path.moveTo((float)cx, (float)(cy - outerRadius));
        for (int i = 0; i < spikes; ++i) {
            path.lineTo((float)cx + (float)Math.cos(rot) * (float)outerRadius, (float)cy + (float)Math.sin(rot) * (float)outerRadius);
            path.lineTo((float)cx + (float)Math.cos(rot += step) * (float)innerRadius, (float)cy + (float)Math.sin(rot) * (float)innerRadius);
            rot += step;
        }
        path.lineTo((float)cx, (float)(cy - outerRadius));
        path.close();
        return path;
    }

    private void createShader() {
        float y1;
        int x1;
        if (this.getWidth() <= 0 && this.getHeight() <= 0) {
            return;
        }
        double w = Math.PI * 2 / (double)this.value;
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint wavePaint = new Paint();
        wavePaint.setStrokeWidth(2.0f);
        wavePaint.setAntiAlias(true);
        float level = (float)(this.mMax - this.mProgress) / (float)this.mMax * (float)this.value + (float)(this.getHeight() / 2 - this.value / 2);
        int x2 = this.getWidth() + 1;
        int y2 = this.getHeight() + 1;
        float zzz = (float)this.value * ((float)(this.waveOffset - 50) / 100.0f) / ((float)this.value / 6.25f);
        float shiftX2 = this.shiftX1 + zzz;
        int waveLevel = this.mStrong * (this.value / 20) / 100;
        wavePaint.setColor(this.mBehindWaveColor);
        for (x1 = 0; x1 < x2; ++x1) {
            y1 = (float)((double)waveLevel * Math.sin(w * (double)x1 + (double)this.shiftX1) + (double)level);
            canvas.drawLine((float)x1, y1, (float)x1, (float)y2, wavePaint);
        }
        wavePaint.setColor(this.mFrontWaveColor);
        for (x1 = 0; x1 < x2; ++x1) {
            y1 = (float)((double)waveLevel * Math.sin(w * (double)x1 + (double)shiftX2) + (double)level);
            canvas.drawLine((float)x1, y1, (float)x1, (float)y2, wavePaint);
        }
        this.mViewPaint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP));
    }

    protected void onDetachedFromWindow() {
        if (this.animHandler != null) {
            this.animHandler.removeCallbacksAndMessages(null);
        }
        if (this.thread != null) {
            this.thread.quit();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        float radius = (float)this.value / 2.0f - this.mBorderWidth;
        float cx = (float)this.getWidth() / 2.0f;
        float cy = (float)this.getHeight() / 2.0f;
        switch (this.mShape) {
            case CIRCLE: {
                canvas.drawCircle(cx, cy, radius, this.mViewPaint);
                if (!(this.mBorderWidth > 0.0f)) break;
                canvas.drawCircle(cx, cy, radius, this.mBorderPaint);
                break;
            }
            case SQUARE: {
                canvas.drawRect(cx - radius, cy - radius, cx + radius, cy + radius, this.mViewPaint);
                if (!(this.mBorderWidth > 0.0f)) break;
                canvas.drawRect(cx - radius, cy - radius, cx + radius, cy + radius, this.mBorderPaint);
                break;
            }
            case HEART: {
                canvas.drawPath(this.pathHeart, this.mViewPaint);
                if (!(this.mBorderWidth > 0.0f)) break;
                canvas.drawPath(this.pathHeart, this.mBorderPaint);
                break;
            }
            case STAR: {
                canvas.drawPath(this.pathStar, this.mViewPaint);
                if (!(this.mBorderWidth > 0.0f)) break;
                canvas.drawPath(this.pathStar, this.mBorderPaint);
            }
        }
        if (!this.isHideText) {
            float percent = (float)(this.mProgress * 100) / (float)this.mMax;
            String text = String.format(Locale.TAIWAN, "%.1f", Float.valueOf(percent)) + "%";
            TextPaint textPaint = new TextPaint();
            textPaint.setColor(this.mTextColor);
            if (this.mShape == Shape.STAR) {
                textPaint.setTextSize((float)this.value / 2.0f / 3.0f);
            } else {
                textPaint.setTextSize((float)this.value / 2.0f / 2.0f);
            }
            textPaint.setAntiAlias(true);
            float textHeight = textPaint.descent() + textPaint.ascent();
            canvas.drawText(text, ((float)this.getWidth() - textPaint.measureText(text)) / 2.0f, ((float)this.getHeight() - textHeight) / 2.0f, (Paint)textPaint);
        }
    }

    private static class UIHandler
    extends Handler {
        private final View mView;

        UIHandler(WeakReference<View> view) {
            super(Looper.getMainLooper());
            this.mView = (View)view.get();
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.mView != null) {
                this.mView.invalidate();
            }
        }
    }

    public static enum Shape {
        CIRCLE(1),
        SQUARE(2),
        HEART(3),
        STAR(4);

        int value;

        private Shape(int value) {
            this.value = value;
        }

        static Shape fromValue(int value) {
            for (Shape shape : Shape.values()) {
                if (shape.value != value) continue;
                return shape;
            }
            return CIRCLE;
        }
    }
}

