/*
 * Decompiled with CFR 0.152.
 */
package com.yangp.ypwaveview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.yangp.ypwaveview.R;
import java.util.Locale;

public class YPWaveView
extends View {
    private float shiftX1 = 0.0f;
    private int strong = 50;
    private float shiftOffset = -0.25f;
    private int waveOffset = 25;
    private int speed = 25;
    private HandlerThread thread = new HandlerThread("YPWaveView" + ((Object)((Object)this)).hashCode());
    private Handler animHandler;
    private Handler uiHandler;
    private Paint mBorderPaint = new Paint();
    private Paint mViewPaint = new Paint();
    private static final int DEFAULT_PROGRESS = 405;
    private static final int DEFAULT_MAX = 1000;
    public static final int DEFAULT_BEHIND_WAVE_COLOR = Color.parseColor((String)"#443030d5");
    public static final int DEFAULT_FRONT_WAVE_COLOR = Color.parseColor((String)"#FF3030d5");
    public static final int DEFAULT_BORDER_COLOR = Color.parseColor((String)"#000000");
    private static final int DEFAULT_BORDER_WIDTH = 5;
    public static final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#000000");
    private static final boolean DEFAULT_ENABLE_ANIMATION = false;
    private int mProgress = 405;
    private int mMax = 1000;
    private int mFrontWaveColor = DEFAULT_FRONT_WAVE_COLOR;
    private int mBehindWaveColor = DEFAULT_BEHIND_WAVE_COLOR;
    private int mBorderColor = DEFAULT_BORDER_COLOR;
    private int mBorderWidth = 5;
    private int mTextColor = DEFAULT_TEXT_COLOR;
    private boolean isAnimation = false;
    private int value = 0;

    public YPWaveView(Context context) {
        this(context, null);
    }

    public YPWaveView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YPWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.YPWaveView, defStyleAttr, 0);
        this.mFrontWaveColor = attributes.getColor(R.styleable.YPWaveView_frontColor, DEFAULT_FRONT_WAVE_COLOR);
        this.mBehindWaveColor = attributes.getColor(R.styleable.YPWaveView_behideColor, DEFAULT_BEHIND_WAVE_COLOR);
        this.mBorderColor = attributes.getColor(R.styleable.YPWaveView_borderColor, DEFAULT_BORDER_COLOR);
        this.mTextColor = attributes.getColor(R.styleable.YPWaveView_textColor, DEFAULT_TEXT_COLOR);
        this.mProgress = attributes.getInt(R.styleable.YPWaveView_progress, 405);
        this.mMax = attributes.getInt(R.styleable.YPWaveView_max, 1000);
        this.mBorderWidth = attributes.getInt(R.styleable.YPWaveView_borderWidth2, 5);
        this.isAnimation = attributes.getBoolean(R.styleable.YPWaveView_animatorEnable, false);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.thread.start();
        this.animHandler = new Handler(this.thread.getLooper());
        this.uiHandler = new UIHandler();
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setProgress(int progress) {
        if (progress <= this.mMax) {
            this.mProgress = progress;
            Message message = Message.obtain((Handler)this.uiHandler);
            message.sendToTarget();
        }
    }

    public void startAnimation() {
        this.isAnimation = true;
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.animHandler.post(new Runnable(){

                @Override
                public void run() {
                    YPWaveView.this.createShader();
                    Message message = Message.obtain((Handler)YPWaveView.this.uiHandler);
                    message.sendToTarget();
                    if (YPWaveView.this.isAnimation) {
                        YPWaveView.this.animHandler.postDelayed((Runnable)this, (long)YPWaveView.this.speed);
                    }
                }
            });
        }
    }

    public void stopAnimation() {
        this.isAnimation = false;
    }

    public void setMax(int max) {
        if (this.mMax != max && max >= this.mProgress) {
            this.mMax = max;
            Message message = Message.obtain((Handler)this.uiHandler);
            message.sendToTarget();
        }
    }

    public void setBorderColor(int color) {
        this.mBorderColor = color;
        this.mBorderPaint.setColor(this.mBorderColor);
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setFrontWaveColor(int color) {
        this.mFrontWaveColor = color;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setBehindWaveColor(int color) {
        this.mBehindWaveColor = color;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setBorderWidth(int width) {
        this.mBorderWidth = width;
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        Message message = Message.obtain((Handler)this.uiHandler);
        message.sendToTarget();
    }

    public void setAnimationSpeed(int speed) {
        this.speed = speed;
    }

    public void setWaveShiftOffset(float offset) {
        this.shiftOffset = offset;
    }

    public void setWaveOffset(int offset) {
        this.waveOffset = offset;
    }

    public void setWaveStrong(int strong) {
        this.strong = strong;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.value = Math.min(w, h);
        this.createShader();
        if (this.isAnimation) {
            this.startAnimation();
        }
    }

    private void createShader() {
        float y1;
        int x1;
        double w = Math.PI * 2 / (double)this.value;
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint wavePaint = new Paint();
        wavePaint.setStrokeWidth(2.0f);
        wavePaint.setAntiAlias(true);
        float level = (float)(this.mMax - this.mProgress) / (float)this.mMax * (float)this.value + (float)(this.getHeight() / 2 - this.value / 2);
        int x2 = this.getWidth() + 1;
        int y2 = this.getHeight() + 1;
        this.shiftX1 += this.shiftOffset;
        float shiftX2 = this.shiftX1 + (float)(this.value * this.waveOffset / 100 / 4);
        int waveLevel = this.strong * (this.value / 20) / 100;
        wavePaint.setColor(this.mBehindWaveColor);
        for (x1 = 0; x1 < x2; ++x1) {
            y1 = (float)((double)waveLevel * Math.sin(w * (double)x1 + (double)this.shiftX1) + (double)level);
            canvas.drawLine((float)x1, y1, (float)x1, (float)y2, wavePaint);
        }
        wavePaint.setColor(this.mFrontWaveColor);
        for (x1 = 0; x1 < x2; ++x1) {
            y1 = (float)((double)waveLevel * Math.sin(w * (double)x1 + (double)shiftX2) + (double)level);
            canvas.drawLine((float)x1, y1, (float)x1, (float)y2, wavePaint);
        }
        float percent = (float)(this.mProgress * 100) / (float)this.mMax;
        String text = String.format(Locale.TAIWAN, "%.1f", Float.valueOf(percent)) + "%";
        TextPaint textPaint = new TextPaint();
        textPaint.setColor(this.mTextColor);
        textPaint.setTextSize((float)this.value / 2.0f / 2.0f);
        textPaint.setAntiAlias(true);
        float textHeight = textPaint.descent() + textPaint.ascent();
        canvas.drawText(text, ((float)this.getWidth() - textPaint.measureText(text)) / 2.0f, ((float)this.getHeight() - textHeight) / 2.0f, (Paint)textPaint);
        this.mViewPaint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP));
    }

    protected void onDetachedFromWindow() {
        if (this.animHandler != null) {
            this.animHandler.removeCallbacksAndMessages(null);
        }
        if (this.thread != null) {
            this.thread.quit();
        }
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.value / 2.0f - (float)this.mBorderWidth, this.mViewPaint);
        if (this.mBorderWidth > 0) {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.value / 2.0f - (float)this.mBorderWidth, this.mBorderPaint);
        }
    }

    class UIHandler
    extends Handler {
        UIHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            YPWaveView.this.invalidate();
        }
    }
}

