/*
 * Decompiled with CFR 0.152.
 */
package com.yangping.mjpegview;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.yangping.mjpegview.MjpegInputStream;
import com.yangping.mjpegview.MjpegRunnable;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class MjpegView
extends SurfaceView
implements SurfaceHolder.Callback,
MjpegInputStream.OnStreamFinishedListener {
    protected static final int SIZE_STANDARD = 1;
    protected static final int SIZE_BEST_FIT = 4;
    protected static final int SIZE_FULLSCREEN = 8;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private boolean isShowFps = true;
    private MjpegRunnable mjpegRunnable;
    private OnMjpegCompletedListener listener = null;

    public MjpegView(Context context) {
        this(context, null, 0);
    }

    public MjpegView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MjpegView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setFocusable(true);
        this.mHandlerThread = new HandlerThread("MjpegView_" + this.hashCode());
        this.mjpegRunnable = new MjpegRunnable(4, null, this.getHolder(), this.isShowFps, false);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mjpegRunnable.setRunning(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mHandlerThread.quitSafely();
        } else {
            this.mHandlerThread.quit();
        }
        this.mHandler = null;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.mjpegRunnable != null) {
            this.mjpegRunnable.setCreatedSurface(true);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        if (this.mjpegRunnable != null) {
            this.mjpegRunnable.setSurfaceSize(i1, i2);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        if (this.mjpegRunnable != null) {
            this.mjpegRunnable.setCreatedSurface(false);
        }
    }

    public void setOnMjpegCompletedListener(OnMjpegCompletedListener listener) {
        this.listener = listener;
    }

    public void startPlayback(MjpegInputStream inputStream) {
        try {
            this.mjpegRunnable.setRunning(true);
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks((Runnable)this.mjpegRunnable);
            } else {
                this.mHandler = new Handler(this.mHandlerThread.getLooper());
            }
            inputStream.setListener(this);
            this.mjpegRunnable.setSurfaceSize(this.getWidth(), this.getHeight());
            this.mjpegRunnable.setInputStream(inputStream);
            this.mHandler.post((Runnable)this.mjpegRunnable);
        }
        catch (Exception e) {
            this.listener.onFailure(e.getMessage());
        }
    }

    public void stopPlayback() {
        if (this.mjpegRunnable != null) {
            this.mjpegRunnable.setRunning(false);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks((Runnable)this.mjpegRunnable);
        }
    }

    private void showFailure(String error) {
        this.listener.onFailure(error);
    }

    public void setFPSEnable(boolean enable) {
        this.isShowFps = enable;
        this.mjpegRunnable.setFpsEnable(enable);
    }

    public void startPlayback(String url) {
        new URLAsyncTask(this).execute(new String[]{url});
    }

    @Override
    public void onFinished() {
        this.stopPlayback();
        new Handler(Looper.myLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (MjpegView.this.listener != null) {
                    MjpegView.this.listener.onCompeleted();
                }
            }
        });
    }

    private static class URLAsyncTask
    extends AsyncTask<String, Object, InputStream> {
        private WeakReference<MjpegView> mView;

        URLAsyncTask(MjpegView view) {
            this.mView = new WeakReference<MjpegView>(view);
        }

        protected InputStream doInBackground(String ... urls) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                URL url = new URL(urls[0]);
                if (url.getProtocol().toUpperCase().equals("HTTPS")) {
                    HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                    connection.setReadTimeout(10000);
                    connection.setConnectTimeout(10000);
                    connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Mobile Safari/537.36");
                    connection.setInstanceFollowRedirects(true);
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        return connection.getInputStream();
                    }
                } else {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setReadTimeout(10000);
                    connection.setConnectTimeout(10000);
                    connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Linux; Android 5.0; SM-G900P Build/LRX21T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Mobile Safari/537.36");
                    connection.setInstanceFollowRedirects(true);
                    connection.setRequestMethod("GET");
                    if (connection.getResponseCode() == 200) {
                        return connection.getInputStream();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ((MjpegView)this.mView.get()).showFailure(e.getMessage());
            }
            return null;
        }

        protected void onPostExecute(InputStream inputStream) {
            super.onPostExecute((Object)inputStream);
            if (inputStream != null) {
                ((MjpegView)this.mView.get()).startPlayback(new MjpegInputStream(inputStream));
            } else {
                ((MjpegView)this.mView.get()).showFailure("InputStream is null.");
            }
        }
    }

    public static interface OnMjpegCompletedListener {
        public void onCompeleted();

        public void onFailure(@NonNull String var1);
    }
}

