/*
 * Decompiled with CFR 0.152.
 */
package com.yangping.mjpegview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;

class MjpegUtil {
    MjpegUtil() {
    }

    static Rect destRect(int displayMode, int disWidth, int disHeight, int bitmapWidth, int bitmapHeight) {
        if (displayMode == 1) {
            int tempx = disWidth / 2 - bitmapWidth / 2;
            int tempy = disHeight / 2 - bitmapHeight / 2;
            return new Rect(tempx, tempy, bitmapWidth + tempx, bitmapHeight + tempy);
        }
        if (displayMode == 4) {
            float bitmapAsp = (float)bitmapWidth / (float)bitmapHeight;
            bitmapWidth = disWidth;
            bitmapHeight = (int)((float)disWidth / bitmapAsp);
            if (bitmapHeight > disHeight) {
                bitmapHeight = disHeight;
                bitmapWidth = (int)((float)disHeight * bitmapAsp);
            }
            int tempx = disWidth / 2 - bitmapWidth / 2;
            int tempy = disHeight / 2 - bitmapHeight / 2;
            return new Rect(tempx, tempy, bitmapWidth + tempx, bitmapHeight + tempy);
        }
        if (displayMode == 8) {
            return new Rect(0, 0, disWidth, disHeight);
        }
        return null;
    }

    static Bitmap makeFpsOverlay(Paint paint, String text) {
        Rect rect = new Rect();
        paint.getTextBounds(text, 0, text.length(), rect);
        int rectWidth = rect.width() + 2;
        int rectHeight = rect.height() + 2;
        Bitmap bitmap = Bitmap.createBitmap((int)rectWidth, (int)rectHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        paint.setColor(-16777216);
        canvas.drawRect(0.0f, 0.0f, (float)rectWidth, (float)rectHeight, paint);
        paint.setColor(-1);
        canvas.drawText(text, (float)(-rect.left + 1), (float)rectHeight / 2.0f - (paint.ascent() + paint.descent()) / 2.0f + 1.0f, paint);
        return bitmap;
    }
}

