/*
 * Decompiled with CFR 0.152.
 */
package com.yangping.mjpegview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.view.SurfaceHolder;
import com.yangping.mjpegview.MjpegInputStream;
import com.yangping.mjpegview.MjpegUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;

class MjpegRunnable
implements Runnable {
    private final int mjpegViewMode;
    private MjpegInputStream inputStream;
    private final SurfaceHolder surfaceHolder;
    private Paint overlayPaint;
    private int disWidth = 0;
    private int disHeight = 0;
    private Rect destRect;
    private Bitmap fpsBitmap;
    private boolean isRunning = true;
    private boolean isCreatedSurface = false;
    private boolean isShowFps = true;
    private int frameCounter = 0;
    private long startTimestamp = 0L;
    private PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_OVER);

    public MjpegRunnable(int mode, MjpegInputStream stream, SurfaceHolder holder, boolean isShowFps, boolean isCreatedSurface) {
        this.inputStream = stream;
        this.mjpegViewMode = mode;
        this.surfaceHolder = holder;
        this.isCreatedSurface = isCreatedSurface;
        this.isShowFps = isShowFps;
        this.overlayPaint = new Paint();
        this.overlayPaint.setTextAlign(Paint.Align.LEFT);
        this.overlayPaint.setTextSize(36.0f);
        this.overlayPaint.setTypeface(Typeface.DEFAULT);
    }

    void setInputStream(MjpegInputStream inputStream) {
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSurfaceSize(int width, int height) {
        SurfaceHolder surfaceHolder = this.surfaceHolder;
        synchronized (surfaceHolder) {
            this.disWidth = width;
            this.disHeight = height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRunning(boolean running) {
        SurfaceHolder surfaceHolder = this.surfaceHolder;
        synchronized (surfaceHolder) {
            this.isRunning = running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCreatedSurface(boolean createdSurface) {
        SurfaceHolder surfaceHolder = this.surfaceHolder;
        synchronized (surfaceHolder) {
            this.isCreatedSurface = createdSurface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFpsEnable(boolean enable) {
        SurfaceHolder surfaceHolder = this.surfaceHolder;
        synchronized (surfaceHolder) {
            this.isShowFps = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.startTimestamp = System.currentTimeMillis();
        Paint paint = new Paint();
        WeakReference<Canvas> canvas = null;
        while (this.isRunning) {
            if (this.isCreatedSurface) {
                try {
                    canvas = new WeakReference<Canvas>(this.surfaceHolder.lockCanvas());
                    long bufferTime = System.currentTimeMillis();
                    SurfaceHolder surfaceHolder = this.surfaceHolder;
                    synchronized (surfaceHolder) {
                        this.synchronizedSurfaceHolder((Canvas)canvas.get(), paint);
                    }
                    long delayTime = 100L - (System.currentTimeMillis() - bufferTime);
                    if (delayTime <= 0L) continue;
                    Thread.sleep(delayTime);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (canvas == null) continue;
                    try {
                        this.surfaceHolder.unlockCanvasAndPost((Canvas)canvas.get());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void synchronizedSurfaceHolder(Canvas canvas, Paint paint) {
        try {
            Bitmap bitmap;
            if (this.inputStream != null && (bitmap = this.inputStream.readMjpegFrame()) != null) {
                canvas.drawColor(-16777216);
                this.destRect = MjpegUtil.destRect(this.mjpegViewMode, this.disWidth, this.disHeight, bitmap.getWidth(), bitmap.getHeight());
                if (this.destRect != null) {
                    canvas.drawBitmap(bitmap, null, this.destRect, paint);
                    if (this.isShowFps) {
                        paint.setXfermode((Xfermode)this.porterDuffXfermode);
                        if (this.fpsBitmap != null) {
                            canvas.drawBitmap(this.fpsBitmap, (float)this.destRect.left, (float)this.destRect.bottom - (float)this.fpsBitmap.getHeight(), null);
                        }
                        paint.setXfermode(null);
                        ++this.frameCounter;
                        if (System.currentTimeMillis() - this.startTimestamp >= 1000L) {
                            this.fpsBitmap = MjpegUtil.makeFpsOverlay(this.overlayPaint, this.frameCounter + "fps");
                            this.frameCounter = 0;
                            this.startTimestamp = System.currentTimeMillis();
                        }
                    }
                    return;
                }
            }
            if (this.destRect != null) {
                canvas.drawBitmap(MjpegUtil.makeFpsOverlay(this.overlayPaint, "00fps"), (float)this.destRect.left, (float)this.destRect.bottom - (float)this.fpsBitmap.getHeight(), null);
            } else {
                canvas.drawColor(-16777216);
                canvas.drawBitmap(MjpegUtil.makeFpsOverlay(this.overlayPaint, "00fps"), 0.0f, (float)(this.disHeight - this.fpsBitmap.getHeight()), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

