/*
 * Decompiled with CFR 0.152.
 */
package com.yan.adapter;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.ViewGroup;
import com.yan.adapter.CustomAdapterItem;
import com.yan.adapter.StateAdapterItem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CustomAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<CustomAdapterItem> customAdapterItems;
    private LinkedList<StateAdapterItem> stateAdapterItems;
    private StateAdapterItem stateHeader;
    private StateAdapterItem stateFooter;
    private List<Integer> stateItemTypes;
    private volatile int stateCurrentSize = 0;
    private List dataList;
    private Integer itemType = 257;
    private boolean[] headerAndFooter = new boolean[2];
    private int headerOffset = 0;

    private synchronized void putItemToEnd(StateAdapterItem item) {
        if (this.stateAdapterItems.size() > 1 && this.stateAdapterItems.getLast() != item) {
            this.stateAdapterItems.remove(item);
            this.stateAdapterItems.addLast(item);
            this.adjustFooterPosition();
        }
    }

    private void adjustFooterPosition() {
        if (this.stateFooter != null && this.stateAdapterItems.get(this.stateCurrentSize - 1) != this.stateFooter) {
            this.stateAdapterItems.remove(this.stateFooter);
            this.stateAdapterItems.add(this.stateCurrentSize - 1, this.stateFooter);
        }
    }

    private synchronized void putItemToTop(StateAdapterItem item) {
        if (this.stateAdapterItems.size() > 1 && this.stateAdapterItems.getFirst() != item) {
            this.stateAdapterItems.remove(item);
            this.stateAdapterItems.addFirst(item);
            this.adjustFooterPosition();
        }
    }

    public synchronized CustomAdapter addAdapterItem(CustomAdapterItem item) {
        if (item instanceof StateAdapterItem) {
            StateAdapterItem stateAdapterItem = (StateAdapterItem)item;
            stateAdapterItem.attach(this);
            if (this.stateAdapterItems == null) {
                this.stateAdapterItems = new LinkedList();
            }
            if (this.stateItemTypes == null) {
                this.stateItemTypes = new ArrayList<Integer>();
            }
            if (stateAdapterItem.getStateItemType() != 0) {
                if (stateAdapterItem.getStateItemType() == 1) {
                    this.headerOffset = 1;
                    if (this.headerAndFooter[0]) {
                        try {
                            throw new Error("can only hold one header");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.headerAndFooter[0] = true;
                    this.stateHeader = stateAdapterItem;
                    return this;
                }
                if (this.headerAndFooter[1]) {
                    try {
                        throw new Error("can only hold one footer");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.headerAndFooter[1] = stateAdapterItem.getStateItemType() == 2;
                this.stateFooter = stateAdapterItem;
                this.stateAdapterItems.add(this.stateFooter);
                if (stateAdapterItem.isShow()) {
                    this.adjustStateSize(1);
                }
                return this;
            }
            if (stateAdapterItem.isShow()) {
                this.adjustStateSize(1);
            }
            this.stateAdapterItems.add(stateAdapterItem);
            this.adjustFooterPosition();
            return this;
        }
        if (this.customAdapterItems == null) {
            this.customAdapterItems = new ArrayList<CustomAdapterItem>();
        }
        this.customAdapterItems.add(item);
        return this;
    }

    public StateAdapterItem findStateItem(String tag) {
        for (StateAdapterItem item : this.stateAdapterItems) {
            if (!tag.equals(item.getTag())) continue;
            return item;
        }
        try {
            throw new Exception("findStateItem Exception : tag " + tag + "not find");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CustomAdapter hideHeader(boolean withCommit) {
        this.headerAndFooter[0] = false;
        this.headerOffset = 0;
        if (withCommit) {
            this.notifyDataSetChanged();
        }
        return this;
    }

    public CustomAdapter showHeader(boolean withCommit) {
        this.headerAndFooter[0] = true;
        this.headerOffset = 1;
        if (withCommit) {
            this.notifyDataSetChanged();
        }
        return this;
    }

    public CustomAdapter hideFooter(boolean withCommit) {
        return this.hide(this.stateFooter, withCommit);
    }

    public CustomAdapter showFooter(boolean withCommit) {
        return this.show(this.stateFooter, withCommit);
    }

    public CustomAdapter show(String tag) {
        StateAdapterItem stateAdapterItem = this.findStateItem(tag);
        return this.show(stateAdapterItem, false);
    }

    public CustomAdapter show(String tag, boolean withCommit) {
        StateAdapterItem stateAdapterItem = this.findStateItem(tag);
        return this.show(stateAdapterItem, withCommit);
    }

    public CustomAdapter show(StateAdapterItem stateItem, boolean withCommit) {
        if (!stateItem.isShow()) {
            stateItem.setShow(true);
            this.adjustStateSize(1);
            this.putItemToTop(stateItem);
            if (withCommit) {
                this.notifyDataSetChanged();
            }
        }
        return this;
    }

    public CustomAdapter hide(String tag) {
        StateAdapterItem stateAdapterItem = this.findStateItem(tag);
        return this.hide(stateAdapterItem, false);
    }

    public CustomAdapter hide(String tag, boolean withCommit) {
        StateAdapterItem stateAdapterItem = this.findStateItem(tag);
        return this.hide(stateAdapterItem, withCommit);
    }

    public CustomAdapter hide(StateAdapterItem stateItem, boolean withCommit) {
        if (stateItem.isShow()) {
            stateItem.setShow(false);
            this.adjustStateSize(-1);
            this.putItemToEnd(stateItem);
            if (withCommit) {
                this.notifyDataSetChanged();
            }
        }
        return this;
    }

    public void commit() {
        this.notifyDataSetChanged();
    }

    public CustomAdapter(List dataList) {
        this.dataList = dataList;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return CustomAdapter.this.stateItemTypes.contains(CustomAdapter.this.getItemViewType(position)) ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            if (holder.getLayoutPosition() == 0 && this.headerAndFooter[0]) {
                p.setFullSpan(true);
            } else if (holder.getLayoutPosition() >= this.dataList.size() + this.headerOffset) {
                p.setFullSpan(true);
            } else {
                p.setFullSpan(false);
            }
        }
    }

    public int getItemViewType(int position) {
        if (this.headerAndFooter[0] && position == 0) {
            if (this.stateHeader.getItemType() == -1) {
                this.itemType = this.itemType + 1;
                this.stateItemTypes.add(this.itemType);
                return this.stateHeader.setItemType(this.itemType);
            }
            return this.stateHeader.getItemType();
        }
        for (CustomAdapterItem item : this.customAdapterItems) {
            if (position - this.headerOffset < this.dataList.size()) {
                if (this.dataList.get(position - this.headerOffset) == null || this.dataList.get(position - this.headerOffset).getClass() != item.dataType()) continue;
                if (item.getItemType() == -1) {
                    this.itemType = this.itemType + 1;
                    return item.setItemType(this.itemType);
                }
                return item.getItemType();
            }
            if (this.stateAdapterItems.get(position - this.headerOffset - this.dataList.size()).getItemType() == -1) {
                this.itemType = this.itemType + 1;
                this.stateItemTypes.add(this.itemType);
                return this.stateAdapterItems.get(position - this.headerOffset - this.dataList.size()).setItemType(this.itemType);
            }
            return this.stateAdapterItems.get(position - this.headerOffset - this.dataList.size()).getItemType();
        }
        return 0;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.stateHeader != null && this.stateHeader.getItemType() == viewType) {
            return this.stateHeader.viewHolder(parent);
        }
        for (CustomAdapterItem customAdapterItem : this.customAdapterItems) {
            if (customAdapterItem.getItemType() != viewType) continue;
            return customAdapterItem.viewHolder(parent);
        }
        for (StateAdapterItem stateAdapterItem : this.stateAdapterItems) {
            if (stateAdapterItem.getItemType() != viewType) continue;
            return stateAdapterItem.viewHolder(parent);
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (!(this.headerAndFooter[0] && position == 0 || position - this.headerOffset >= this.dataList.size())) {
            for (CustomAdapterItem item : this.customAdapterItems) {
                if (this.dataList.get(position - this.headerOffset) == null || item.dataType() != this.dataList.get(position - this.headerOffset).getClass()) continue;
                item.bindData(holder, this.dataList.get(position - this.headerOffset), position - this.headerOffset);
                break;
            }
        }
    }

    private synchronized void adjustStateSize(int stateCurrentSize) {
        this.stateCurrentSize += stateCurrentSize;
    }

    public int getItemCount() {
        return this.dataList.size() + this.stateCurrentSize + (this.headerAndFooter[0] ? 1 : 0);
    }
}

