/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class HealthCheckBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Log log = LogFactory.getLog(HealthCheckBeanPostProcessor.class);
    private final HealthCheckRegistry healthChecks;

    public HealthCheckBeanPostProcessor(HealthCheckRegistry healthChecks) {
        this.healthChecks = healthChecks;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HealthCheck) {
            this.healthChecks.register((HealthCheck)bean);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering HealthCheck bean " + beanName));
            }
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

