/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring.config;

import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.spring.ExceptionMeteredAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.GaugeAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.HealthCheckBeanPostProcessor;
import com.yammer.metrics.spring.MeteredAnnotationBeanPostProcessor;
import com.yammer.metrics.spring.TimedAnnotationBeanPostProcessor;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String scope;
        String healthCheckBeanName;
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        String metricsBeanName = element.getAttribute("metrics-registry");
        if (!StringUtils.hasText((String)metricsBeanName)) {
            metricsBeanName = this.registerComponent(parserContext, this.build(Metrics.class, source, 0).setFactoryMethod("defaultRegistry"));
        }
        if (!StringUtils.hasText((String)(healthCheckBeanName = element.getAttribute("health-check-registry")))) {
            healthCheckBeanName = this.registerComponent(parserContext, this.build(HealthChecks.class, source, 0).setFactoryMethod("defaultRegistry"));
        }
        if (!StringUtils.hasText((String)(scope = element.getAttribute("scope")))) {
            scope = null;
        }
        ProxyConfig proxyConfig = new ProxyConfig();
        if (StringUtils.hasText((String)element.getAttribute("expose-proxy"))) {
            proxyConfig.setExposeProxy(Boolean.valueOf(element.getAttribute("expose-proxy")).booleanValue());
        }
        if (StringUtils.hasText((String)element.getAttribute("proxy-target-class"))) {
            proxyConfig.setProxyTargetClass(Boolean.valueOf(element.getAttribute("proxy-target-class")).booleanValue());
        }
        this.registerComponent(parserContext, this.build(ExceptionMeteredAnnotationBeanPostProcessor.class, source, 2).addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig).addConstructorArgValue((Object)scope));
        this.registerComponent(parserContext, this.build(MeteredAnnotationBeanPostProcessor.class, source, 2).addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig).addConstructorArgValue((Object)scope));
        this.registerComponent(parserContext, this.build(TimedAnnotationBeanPostProcessor.class, source, 2).addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)proxyConfig).addConstructorArgValue((Object)scope));
        this.registerComponent(parserContext, this.build(GaugeAnnotationBeanPostProcessor.class, source, 2).addConstructorArgReference(metricsBeanName).addConstructorArgValue((Object)scope));
        this.registerComponent(parserContext, this.build(HealthCheckBeanPostProcessor.class, source, 2).addConstructorArgReference(healthCheckBeanName));
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private BeanDefinitionBuilder build(Class<?> klazz, Object source, int role) {
        BeanDefinitionBuilder beanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(klazz);
        beanDefBuilder.setRole(role);
        beanDefBuilder.getRawBeanDefinition().setSource(source);
        return beanDefBuilder;
    }

    private String registerComponent(ParserContext parserContext, BeanDefinitionBuilder beanDefBuilder) {
        AbstractBeanDefinition beanDef = beanDefBuilder.getBeanDefinition();
        String beanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDef);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDef, beanName));
        return beanName;
    }
}

