/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.annotation.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.spring.AnnotationFilter;
import com.yammer.metrics.spring.GaugeField;
import com.yammer.metrics.spring.GaugeMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class GaugeAnnotationBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Log log = LogFactory.getLog(GaugeAnnotationBeanPostProcessor.class);
    private static final AnnotationFilter filter = new AnnotationFilter(Gauge.class);
    private final MetricsRegistry metrics;
    private final String scope;

    public GaugeAnnotationBeanPostProcessor(MetricsRegistry metrics, String scope) {
        this.metrics = metrics;
        this.scope = scope;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        final Class targetClass = AopUtils.getTargetClass((Object)bean);
        ReflectionUtils.doWithFields((Class)targetClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Gauge gauge = field.getAnnotation(Gauge.class);
                String group = MetricName.chooseGroup((String)gauge.group(), (Class)targetClass);
                String type = MetricName.chooseType((String)gauge.type(), (Class)targetClass);
                String name = gauge.name().isEmpty() ? field.getName() : gauge.name();
                MetricName metricName = new MetricName(group, type, name, GaugeAnnotationBeanPostProcessor.this.scope);
                GaugeAnnotationBeanPostProcessor.this.metrics.newGauge(metricName, (com.yammer.metrics.core.Gauge)new GaugeField(bean, field));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created gauge " + metricName + " for field " + targetClass.getCanonicalName() + "." + field.getName()));
                }
            }
        }, (ReflectionUtils.FieldFilter)filter);
        ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (method.getParameterTypes().length > 0) {
                    throw new IllegalStateException("Method " + method.getName() + " is annotated with @Gauge but requires parameters.");
                }
                Gauge gauge = method.getAnnotation(Gauge.class);
                String group = MetricName.chooseGroup((String)gauge.group(), (Class)targetClass);
                String type = MetricName.chooseType((String)gauge.type(), (Class)targetClass);
                String name = MetricName.chooseName((String)gauge.name(), (Method)method);
                MetricName metricName = new MetricName(group, type, name, GaugeAnnotationBeanPostProcessor.this.scope);
                GaugeAnnotationBeanPostProcessor.this.metrics.newGauge(metricName, (com.yammer.metrics.core.Gauge)new GaugeMethod(bean, method));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created gauge " + metricName + " for method " + targetClass.getCanonicalName() + "." + method.getName()));
                }
            }
        }, (ReflectionUtils.MethodFilter)filter);
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

