/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.spring;

import com.yammer.metrics.annotation.Timed;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.spring.AnnotationMethodFilter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class TimedMethodInterceptor
implements MethodInterceptor,
ReflectionUtils.MethodCallback,
Ordered {
    private static final ReflectionUtils.MethodFilter filter = new AnnotationMethodFilter(Timed.class);
    private final MetricsRegistry metrics;
    private final Class<?> targetClass;
    private final Map<String, Timer> timers;

    public TimedMethodInterceptor(MetricsRegistry metrics, Class<?> targetClass) {
        this.metrics = metrics;
        this.targetClass = targetClass;
        this.timers = new HashMap<String, Timer>();
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)this, (ReflectionUtils.MethodFilter)filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        TimerContext tc = this.timers.get(invocation.getMethod().getName()).time();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            tc.stop();
        }
    }

    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
        Timed timed = method.getAnnotation(Timed.class);
        String methodName = method.getName();
        String timerName = timed.name().isEmpty() ? methodName : timed.name();
        Timer timer = this.metrics.newTimer(this.targetClass, timerName, timed.durationUnit(), timed.rateUnit());
        this.timers.put(methodName, timer);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

